/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fitlibrary.DoFixture;
import fitlibrary.differences.DifferenceInterface;
import fitlibrary.log.Logging;
import fitlibrary.runner.FolderRunner;
import fitlibrary.runner.Report;
import fitlibrary.traverse.Traverse;
import fitlibrary.utility.StringUtility;
import java.io.File;

public class FolderRunnerFixture
extends DoFixture {
    private static final String TESTFILES = "../";

    public void log() {
        Logging.setLogging(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runGiving(String testDirectoryName, String reportDirectoryName) throws Exception {
        DifferenceInterface previousDifferenceStrategy = Traverse.getDifferenceStrategy();
        try {
            long start = System.currentTimeMillis();
            Report run = new FolderRunner().run(TESTFILES + testDirectoryName, TESTFILES + reportDirectoryName);
            String theCounts = run.getCounts();
            long end = System.currentTimeMillis();
            this.showAfterTable(theCounts + " in " + (end - start) / 1000L + " seconds");
            boolean bl = !run.failing();
            return bl;
        }
        finally {
            Traverse.setDifferenceStrategy(previousDifferenceStrategy);
        }
    }

    private String urlFile(String fileName, String title) {
        String url = StringUtility.replaceString("file:///" + new File(fileName).getAbsolutePath(), " ", "%20");
        url = StringUtility.replaceString(url, "\\", "/");
        return "<a href=\"" + url + "\">" + title + url + "</a>";
    }
}

