/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runner;

import fit.Parse;
import fitlibrary.runner.HtmlRunner;
import fitlibrary.utility.ParseUtility;
import java.text.ParseException;
import junit.framework.TestCase;

public class TestHtmlRunner
extends TestCase {
    private static final String html = "<html><title>table</title><body>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>";
    private static String setUpHtml = "<html><title>setup</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4</body></html>";
    private static String tearDownHtml = "<html><title>teardown</title><body>front<table><tr><td>TearDown</td></tr></table>backT3<table><tr><td>TearDown</td></tr></table>T4</body></html>";
    private Parse tables;
    private Parse setUp;
    private Parse tearDown;

    public void setUp() throws ParseException {
        this.tables = new Parse(html);
        this.setUp = new Parse(setUpHtml);
        this.tearDown = new Parse(tearDownHtml);
    }

    public void testNone() {
        this.check(null, null, html);
    }

    public void testSetUp() {
        String string = "<html><title>table</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4<br>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4</body></html>";
        this.check(this.setUp, null, string);
    }

    public void testTearDown() {
        String string = "<html><title>table</title><body>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4<br>front<table><tr><td>TearDown</td></tr></table>backT3<table><tr><td>TearDown</td></tr></table>T4</body></html>";
        this.check(null, this.tearDown, string);
    }

    public void testSetUpAndTearDown() {
        String string = "<html><title>table</title><body>s1<table><tr><td>SetUp</td></tr></table>s2s3<table><tr><td>SetUp</td></tr></table>s4<br>t1<table><tr><td>Test</td></tr></table>t2t3<table><tr><td>Test</td></tr></table>t4<br>front<table><tr><td>TearDown</td></tr></table>backT3<table><tr><td>TearDown</td></tr></table>T4</body></html>";
        this.check(this.setUp, this.tearDown, string);
    }

    private void check(Parse parse, Parse parse2, String string) {
        Parse parse3 = HtmlRunner.integrateSetUpAndTearDown(this.tables, parse, parse2);
        this.assertEquals(string, parse3);
    }

    private void assertEquals(String string, Parse parse) {
        TestHtmlRunner.assertEquals((String)string, (String)ParseUtility.toString(parse));
    }
}

