/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runtime;

import fitlibrary.config.Configuration;
import fitlibrary.dynamicVariable.DynamicVariables;
import fitlibrary.dynamicVariable.DynamicVariablesRecording;
import fitlibrary.dynamicVariable.DynamicVariablesRecordingThatFails;
import fitlibrary.dynamicVariable.DynamicVariablesRecordingToFile;
import fitlibrary.dynamicVariable.GlobalDynamicVariables;
import fitlibrary.dynamicVariable.LocalDynamicVariables;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.flow.IScope;
import fitlibrary.listener.OnError;
import fitlibrary.log.ConfigureLog4j;
import fitlibrary.log.FitLibraryLogger;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.FoldingTexts;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.runtime.SuiteWideRuntimeContext;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.Tables;
import fitlibrary.tableProxy.CellProxy;
import fitlibrary.tableProxy.RowProxy;
import fitlibrary.traverse.TableEvaluator;
import fitlibrary.traverse.workflow.caller.DefinedActionCallManager;
import fitlibrary.typed.TypedObject;
import fitlibrary.utility.ExtendedCamelCase;
import fitlibrary.utility.Pair;
import java.io.IOException;
import java.util.Stack;
import org.apache.log4j.Logger;

public class RuntimeContextContainer
implements RuntimeContextInternal {
    private static Logger logger = FitLibraryLogger.getLogger(RuntimeContextContainer.class);
    private static final String EXPAND_DEFINED_ACTIONS = "$$expandDefinedActions$$";
    private SuiteWideRuntimeContext suiteWideRuntimeContext;
    protected DynamicVariables dynamicVariables = new GlobalDynamicVariables();
    private DynamicVariablesRecording dynamicVariablesRecording = new DynamicVariablesRecordingThatFails();
    private DefinedActionCallManager definedActionCallManager = new DefinedActionCallManager();
    private FoldingTexts foldingTexts = new FoldingTexts();
    protected TestResults testResults;
    private Stack<TestResults> testResultsStack = new Stack();
    protected Row currentRow;
    protected Table currentTable;
    private String currentPageName = "";
    private ConfigureLog4j configureLog4j;
    private OnError onErrorHandler = new OnError(){

        @Override
        public boolean stopOnError(int fails, int errors) {
            return false;
        }
    };

    public RuntimeContextContainer() {
        this(null, new GlobalActionScope());
    }

    public RuntimeContextContainer(IScope scope, GlobalActionScope global) {
        this.suiteWideRuntimeContext = new SuiteWideRuntimeContext(scope, global);
        global.setRuntimeContext(this);
        this.configureLog4j = new ConfigureLog4j(this);
    }

    public RuntimeContextContainer(String[] s) {
        for (int i = 0; i < s.length - 1; i += 2) {
            this.dynamicVariables.put(s[i], s[i + 1]);
        }
    }

    protected RuntimeContextContainer(DynamicVariables dynamicVariables, SuiteWideRuntimeContext suiteWideRuntimeContext, ConfigureLog4j configureLog4j, FoldingTexts foldingTexts) {
        this.dynamicVariables = dynamicVariables;
        this.suiteWideRuntimeContext = suiteWideRuntimeContext;
        this.configureLog4j = configureLog4j;
        this.foldingTexts = foldingTexts;
    }

    @Override
    public RuntimeContextInternal copyFromSuite() {
        logger.trace((Object)("Use Suite dynamic variables " + this.dynamicVariables.top()));
        return new RuntimeContextContainer(new GlobalDynamicVariables(this.dynamicVariables.top()), this.suiteWideRuntimeContext, this.configureLog4j, this.foldingTexts);
    }

    @Override
    public void reset() {
        this.dynamicVariables = new GlobalDynamicVariables();
        this.suiteWideRuntimeContext.reset();
    }

    @Override
    public DynamicVariables getDynamicVariables() {
        return this.dynamicVariables;
    }

    public String toString() {
        return this.getDynamicVariables().toString();
    }

    @Override
    public void putTimeout(String name, int timeout) {
        this.suiteWideRuntimeContext.putTimeout(name, timeout);
    }

    @Override
    public int getTimeout(String name, int defaultTimeout) {
        return this.suiteWideRuntimeContext.getTimeout(name, defaultTimeout);
    }

    @Override
    public void startLogging(String fileName) {
        this.suiteWideRuntimeContext.startLogging(fileName);
    }

    @Override
    public void printToLog(String s) throws IOException {
        this.suiteWideRuntimeContext.printToLog(s);
    }

    @Override
    public void pushLocalDynamicVariables() {
        this.dynamicVariables = new LocalDynamicVariables(this.dynamicVariables);
    }

    @Override
    public void popLocalDynamicVariables() {
        this.dynamicVariables = this.dynamicVariables.popLocal();
    }

    @Override
    public void setDynamicVariable(String key, Object value) {
        this.dynamicVariables.put(key, value);
    }

    @Override
    public Object getDynamicVariable(String key) {
        return this.dynamicVariables.get(key);
    }

    @Override
    public boolean toExpandDefinedActions() {
        return "true".equals(this.getDynamicVariable(EXPAND_DEFINED_ACTIONS));
    }

    @Override
    public void setExpandDefinedActions(boolean expandDefinedActions) {
        this.setDynamicVariable(EXPAND_DEFINED_ACTIONS, "" + expandDefinedActions);
    }

    @Override
    public IScope getScope() {
        return this.suiteWideRuntimeContext.getScope();
    }

    public void setTableEvaluator(TableEvaluator evaluator) {
        this.suiteWideRuntimeContext.setTableEvaluator(evaluator);
    }

    @Override
    public TableEvaluator getTableEvaluator() {
        return this.suiteWideRuntimeContext.getTableEvaluator();
    }

    @Override
    public GlobalActionScope getGlobal() {
        return this.suiteWideRuntimeContext.getGlobal();
    }

    @Override
    public void showAsAfterTable(String title, String s) {
        this.foldingTexts.logAsAfterTable(title, s);
    }

    @Override
    public void show(String s) {
        this.currentRow.addCell(s).shown();
        this.getDefinedActionCallManager().addShow(this.currentRow);
    }

    @Override
    public void addAccumulatedFoldingText(Table table) {
        this.foldingTexts.addAccumulatedFoldingText(table);
    }

    @Override
    public void recordToFile(String fileName) {
        this.dynamicVariablesRecording = new DynamicVariablesRecordingToFile(fileName);
    }

    @Override
    public DynamicVariablesRecording getDynamicVariableRecorder() {
        return this.dynamicVariablesRecording;
    }

    @Override
    public void setAbandon(boolean abandon) {
        this.suiteWideRuntimeContext.setAbandon(abandon);
    }

    @Override
    public boolean isAbandoned(TestResults testResults2) {
        return this.suiteWideRuntimeContext.isAbandoned(testResults2);
    }

    @Override
    public void setStopOnError(boolean stop) {
        this.suiteWideRuntimeContext.setStopOnError(stop);
    }

    @Override
    public DefinedActionCallManager getDefinedActionCallManager() {
        return this.definedActionCallManager;
    }

    @Override
    public VariableResolver getResolver() {
        return this;
    }

    @Override
    public Pair<String, Tables> resolve(String key) {
        return this.getDynamicVariables().resolve(key);
    }

    @Override
    public void setCurrentRow(Row row) {
        this.currentRow = row;
    }

    @Override
    public void setCurrentTable(Table table) {
        this.currentTable = table;
    }

    @Override
    public boolean hasRowsAfter(Row row) {
        if (this.currentTable == null || this.currentRow == null) {
            return false;
        }
        return this.currentTable.hasRowsAfter(this.currentRow);
    }

    @Override
    public TestResults getTestResults() {
        return this.testResults;
    }

    @Override
    public void pushTestResults(TestResults results) {
        this.testResultsStack.push(this.testResults);
        this.testResults = results;
    }

    @Override
    public void popTestResults() {
        this.testResults = this.testResultsStack.pop();
    }

    @Override
    public CellProxy cellAt(int i) {
        final Cell cell = (Cell)this.currentRow.at(i);
        return new CellProxy(){

            @Override
            public void pass() {
                cell.pass(RuntimeContextContainer.this.testResults);
            }

            @Override
            public void pass(String msg) {
                cell.pass(RuntimeContextContainer.this.testResults, msg);
            }

            @Override
            public void fail(String msg) {
                if (msg.isEmpty()) {
                    cell.fail(RuntimeContextContainer.this.testResults);
                } else {
                    cell.fail(RuntimeContextContainer.this.testResults, msg, RuntimeContextContainer.this.dynamicVariables);
                }
            }

            @Override
            public void failHtml(String msg) {
                cell.failHtml(RuntimeContextContainer.this.testResults, msg);
            }

            @Override
            public void fail() {
                cell.fail(RuntimeContextContainer.this.testResults);
            }

            @Override
            public void error(String msg) {
                if (msg.isEmpty()) {
                    cell.error(RuntimeContextContainer.this.testResults);
                } else {
                    cell.error(RuntimeContextContainer.this.testResults, msg);
                }
            }

            @Override
            public void error(Throwable e) {
                cell.error(RuntimeContextContainer.this.testResults, e);
            }

            @Override
            public void error() {
                cell.error(RuntimeContextContainer.this.testResults);
            }
        };
    }

    @Override
    public RowProxy currentRow() {
        return new RowProxy(){

            @Override
            public void addShow(String s) {
                RuntimeContextContainer.this.currentRow.addCell(s).shown();
            }
        };
    }

    @Override
    public Table currentTable() {
        return this.currentTable;
    }

    @Override
    public void setCurrentPageName(String pageName) {
        this.currentPageName = pageName;
    }

    @Override
    public String getCurrentPageName() {
        return this.currentPageName;
    }

    @Override
    public ConfigureLog4j getConfigureLog4j() {
        return this.configureLog4j;
    }

    @Override
    public void addNamedObject(String name, TypedObject typedObject) {
        this.suiteWideRuntimeContext.addNamedObject(name, typedObject);
    }

    @Override
    public Configuration getConfiguration() {
        return this.suiteWideRuntimeContext;
    }

    @Override
    public String extendedCamel(String s) {
        return ExtendedCamelCase.camel(s, this.suiteWideRuntimeContext.keepingUniCode());
    }

    @Override
    public Row row() {
        return this.currentRow;
    }

    @Override
    public void registerOnErrorHandler(OnError onError) {
        this.onErrorHandler = onError;
    }

    @Override
    public void checkStopOnError(TestResults testResults2) {
        if (this.onErrorHandler.stopOnError(testResults2.getCounts().wrong, testResults2.getCounts().exceptions)) {
            this.getScope().setAbandon(true);
        }
    }
}

