/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.runtime;

import fitlibrary.runtime.RuntimeContextContainer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class TestRuntimeContext {
    @Test(expected=RuntimeException.class)
    public void cannotPutParameterWithGlobal() {
        new RuntimeContextContainer().getDynamicVariables().putParameter("k", "v");
    }

    @Test
    public void canPutParameterOncePushedLocal() {
        RuntimeContextContainer runtimeContextContainer = new RuntimeContextContainer();
        runtimeContextContainer.pushLocalDynamicVariables();
        runtimeContextContainer.getDynamicVariables().putParameter("k", "v");
        MatcherAssert.assertThat((Object)runtimeContextContainer.getDynamicVariables().get("k"), (Matcher)CoreMatchers.is((Object)"v"));
    }

    @Test
    public void canPopLocalOncePushedLocal() {
        RuntimeContextContainer runtimeContextContainer = new RuntimeContextContainer();
        runtimeContextContainer.pushLocalDynamicVariables();
        runtimeContextContainer.popLocalDynamicVariables();
    }

    @Test(expected=RuntimeException.class)
    public void cannotPopLocalIfNotPushedLocal() {
        RuntimeContextContainer runtimeContextContainer = new RuntimeContextContainer();
        runtimeContextContainer.popLocalDynamicVariables();
    }

    @Test
    public void parameterBindingsAreDiscardedOnPop() {
        RuntimeContextContainer runtimeContextContainer = new RuntimeContextContainer();
        runtimeContextContainer.pushLocalDynamicVariables();
        runtimeContextContainer.getDynamicVariables().putParameter("k", "v");
        MatcherAssert.assertThat((Object)runtimeContextContainer.getDynamicVariables().get("k"), (Matcher)CoreMatchers.is((Object)"v"));
        runtimeContextContainer.popLocalDynamicVariables();
        MatcherAssert.assertThat((Object)(runtimeContextContainer.getDynamicVariables().get("k") == null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void previousParameterBindingsAreAvailableOnPop() {
        RuntimeContextContainer runtimeContextContainer = new RuntimeContextContainer();
        runtimeContextContainer.pushLocalDynamicVariables();
        runtimeContextContainer.getDynamicVariables().putParameter("k", "v");
        runtimeContextContainer.pushLocalDynamicVariables();
        MatcherAssert.assertThat((Object)runtimeContextContainer.getDynamicVariables().get("k"), (Matcher)CoreMatchers.is((Object)"v"));
        runtimeContextContainer.getDynamicVariables().putParameter("k", "V");
        MatcherAssert.assertThat((Object)runtimeContextContainer.getDynamicVariables().get("k"), (Matcher)CoreMatchers.is((Object)"V"));
        runtimeContextContainer.popLocalDynamicVariables();
        MatcherAssert.assertThat((Object)runtimeContextContainer.getDynamicVariables().get("k"), (Matcher)CoreMatchers.is((Object)"v"));
        runtimeContextContainer.popLocalDynamicVariables();
        MatcherAssert.assertThat((Object)(runtimeContextContainer.getDynamicVariables().get("k") == null ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }
}

