/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec;

import fit.Parse;
import fit.exception.FitParseException;
import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.spec.PipeLine;
import fitlibrary.spec.SpecifyErrorReport;
import fitlibrary.spec.filter.FoldFilter;
import fitlibrary.spec.filter.StackTraceFilter;
import fitlibrary.spec.matcher.FitLabelMatcher;
import fitlibrary.spec.matcher.ImageSrcMatcher;
import fitlibrary.spec.matcher.StringMatcher;
import fitlibrary.table.Cell;
import fitlibrary.table.Table;
import fitlibrary.table.TableElement;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import java.util.Iterator;

public class TablesCompare {
    private final SpecifyErrorReport errorReport;
    private final VariableResolver resolver;
    private final PipeLine matcherPipeline = new FoldFilter(new StackTraceFilter(new FitLabelMatcher(new ImageSrcMatcher(new StringMatcher()))));

    public TablesCompare(SpecifyErrorReport errorReport, VariableResolver resolver) {
        this.errorReport = errorReport;
        this.resolver = resolver;
    }

    public boolean tablesEqual(String path, TableElement actualInitial, TableElement expectedInitial) {
        TableElement actual = actualInitial;
        TableElement expected = expectedInitial;
        boolean actualContainsHtmlDueToShow = false;
        if (actual instanceof Cell) {
            Cell actualCell = (Cell)actual;
            Cell expectedCell = (Cell)expected;
            if (expectedCell.hasEmbeddedTables(this.resolver) && !actualCell.fullText().isEmpty() && expectedCell.fullText().isEmpty()) {
                expectedCell.setText(((Table)expectedCell.last()).getTrailer());
                ((Table)expectedCell.last()).setTrailer("");
            }
            if (!this.equals(actualCell.fullText(), expectedCell.fullText())) {
                if (!actualCell.hasEmbeddedTables(this.resolver) && expectedCell.hasEmbeddedTables(this.resolver)) {
                    try {
                        TableFactory.useOnLists(false);
                        Tables actualTables = TableFactory.tables(new Parse(actualCell.fullText()));
                        TableFactory.pop();
                        if (!this.tablesEqual(path, actualTables, expectedCell.getEmbeddedTables())) {
                            return false;
                        }
                        actualContainsHtmlDueToShow = true;
                    }
                    catch (FitParseException e) {
                        this.errorReport.cellTextWrong(path, actualCell.fullText(), expectedCell.fullText());
                        return false;
                    }
                } else {
                    this.errorReport.cellTextWrong(path, actualCell.fullText(), expectedCell.fullText());
                    return false;
                }
            }
            actual = actualCell.getEmbeddedTables();
            expected = expectedCell.getEmbeddedTables();
        }
        if (!actualContainsHtmlDueToShow) {
            if (!(expected.getLeader().isEmpty() && actual.getLeader().equals("<html>") || this.equals(actual.getLeader(), expected.getLeader()))) {
                this.errorReport.leaderWrong(path, actual.getLeader(), expected.getLeader());
                return false;
            }
            if (!(expected.getTrailer().isEmpty() && actual.getTrailer().equals("</html>") || this.equals(actual.getTrailer(), expected.getTrailer()))) {
                this.errorReport.trailerWrong(path, actual.getTrailer(), expected.getTrailer());
                return false;
            }
            if (!(expected.getTagLine().isEmpty() && actual.getTagLine().equals("border=\"1\" cellspacing=\"0\"") || actual.getTagLine().equals(expected.getTagLine()))) {
                this.errorReport.tagLineWrong(path, actual.getTagLine(), expected.getTagLine());
                return false;
            }
            if (actual.size() != expected.size()) {
                this.errorReport.sizeWrong(path, actual.size(), expected.size());
                return false;
            }
        }
        Iterator actuals = actual.iterator();
        Iterator expecteds = expected.iterator();
        int count = 0;
        while (actuals.hasNext()) {
            String pathFurther;
            TableElement act = (TableElement)actuals.next();
            String nameOfElement = act.getType() + "[" + count + "]";
            String string = pathFurther = path.isEmpty() ? nameOfElement : path + "." + nameOfElement;
            if (!this.tablesEqual(pathFurther, act, (TableElement)expecteds.next())) {
                return false;
            }
            ++count;
        }
        return true;
    }

    public boolean equals(String actualString, String expectedString) {
        String actual = this.canonical(actualString);
        String expected = this.canonical(expectedString);
        if ("IGNORE".equals(expected)) {
            return true;
        }
        return this.matcherPipeline.match(actual, expected);
    }

    private String canonical(String s) {
        return s.replaceAll("\t", " ").replaceAll("\r", "").replaceAll("<hr>", "").replaceAll("&nbsp;", "").replaceAll("<hr/>", "").replaceAll("<br>", "").replaceAll("<br/>", "").replaceAll("\n", "").trim();
    }

    static class MismatchException
    extends Exception {
        private static final long serialVersionUID = 1L;

        MismatchException() {
        }
    }
}

