/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.matcher.TableBuilderForTests;
import fitlibrary.runResults.TestResults;
import fitlibrary.spec.SpecifyErrorReport;
import fitlibrary.spec.SpecifyFixture;
import fitlibrary.suite.StorytestRunner;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestSpecifyFixture {
    final Mockery context = new Mockery();
    final StorytestRunner runner = (StorytestRunner)this.context.mock(StorytestRunner.class);
    final SpecifyErrorReport errorReport = (SpecifyErrorReport)this.context.mock(SpecifyErrorReport.class);
    final SpecifyFixture specifyFixture = new SpecifyFixture(this.runner, this.errorReport);
    final TestResults testResults = (TestResults)this.context.mock(TestResults.class);
    Tables actual = TableFactory.tables();
    Tables expected = TableFactory.tables();

    @Test
    public void anExceptionIsThrownIfNoTablesForActual() {
        final Table table = this.specifyingTable(TableBuilderForTests.cell(), TableBuilderForTests.cell());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.oneOf(table)).error((TestResults)this.with(TestSpecifyFixture.this.testResults), (Throwable)this.with(1.any(FitLibraryException.class)));
            }
        });
        this.specifyFixture.interpretAfterFirstRow(table, this.testResults);
    }

    @Test
    public void singleTableAndTextMatches() {
        final Table table = this.specifyingTable(TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell("abc"), TableBuilderForTests.cell("de"), TableBuilderForTests.cell("fg"))), TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell("abc"), TableBuilderForTests.cell("de"), TableBuilderForTests.cell("fg"))));
        this.storytestRunnerIsCalled(table);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Cell)this.oneOf(TestSpecifyFixture.this.expectedCell(table))).pass(TestSpecifyFixture.this.testResults);
                ((TestResults)this.oneOf(TestSpecifyFixture.this.testResults)).addRights(2);
            }
        });
        this.specifyFixture.interpretAfterFirstRow(table, this.testResults);
    }

    @Test
    public void textOfCellDoesNotMatch() {
        final Table table = this.specifyingTable(TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell("ab"))), TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell("cd"))));
        this.storytestRunnerIsCalled(table);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecifyErrorReport)this.oneOf(TestSpecifyFixture.this.errorReport)).cellTextWrong("Table[0].Row[0].Cell[0]", "ab", "cd");
                ((Cell)this.oneOf(TestSpecifyFixture.this.expectedCell(table))).fail(TestSpecifyFixture.this.testResults);
                ((SpecifyErrorReport)this.oneOf(TestSpecifyFixture.this.errorReport)).actualResult(TestSpecifyFixture.this.actualCell(table));
            }
        });
        this.specifyFixture.interpretAfterFirstRow(table, this.testResults);
    }

    @Test
    public void leaderOfTableDoesNotMatch() {
        final Table table = this.specifyingTable(TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell("ab")).withLeader("lead1")), TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell("ab")).withLeader("lead2")));
        this.storytestRunnerIsCalled(table);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecifyErrorReport)this.oneOf(TestSpecifyFixture.this.errorReport)).leaderWrong("Table[0]", "lead1", "lead2");
                ((Cell)this.oneOf(TestSpecifyFixture.this.expectedCell(table))).fail(TestSpecifyFixture.this.testResults);
                ((SpecifyErrorReport)this.oneOf(TestSpecifyFixture.this.errorReport)).actualResult(TestSpecifyFixture.this.actualCell(table));
            }
        });
        this.specifyFixture.interpretAfterFirstRow(table, this.testResults);
    }

    @Test
    public void trailerOfTableDoesNotMatch() {
        final Table table = this.specifyingTable(TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell("ab")).withTrailer("lead1")), TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell("ab")).withTrailer("lead2")));
        this.storytestRunnerIsCalled(table);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecifyErrorReport)this.oneOf(TestSpecifyFixture.this.errorReport)).trailerWrong("Table[0]", "lead1", "lead2");
                ((Cell)this.oneOf(TestSpecifyFixture.this.expectedCell(table))).fail(TestSpecifyFixture.this.testResults);
                ((SpecifyErrorReport)this.oneOf(TestSpecifyFixture.this.errorReport)).actualResult(TestSpecifyFixture.this.actualCell(table));
            }
        });
        this.specifyFixture.interpretAfterFirstRow(table, this.testResults);
    }

    @Test
    public void tagLineOfCellDoesNotMatch() {
        final Table table = this.specifyingTable(TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell("ab").withTagLine("pass"))), TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell("ab").withTagLine("fail"))));
        this.storytestRunnerIsCalled(table);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SpecifyErrorReport)this.oneOf(TestSpecifyFixture.this.errorReport)).tagLineWrong("Table[0].Row[0].Cell[0]", "pass", "fail");
                ((Cell)this.oneOf(TestSpecifyFixture.this.expectedCell(table))).fail(TestSpecifyFixture.this.testResults);
                ((SpecifyErrorReport)this.oneOf(TestSpecifyFixture.this.errorReport)).actualResult(TestSpecifyFixture.this.actualCell(table));
            }
        });
        this.specifyFixture.interpretAfterFirstRow(table, this.testResults);
    }

    @Test
    public void ignoresCR() {
        this.theseAreConsideredTheSame("abc\r", "\rabc");
    }

    @Test
    public void ignoresLeadingAndTrailingSpaces() {
        this.theseAreConsideredTheSame("abc  ", " abc");
    }

    @Test
    public void treatsTabAsASingleSpace() {
        this.theseAreConsideredTheSame("a b\tc", " a\tb c");
    }

    @Test
    public void treatsTheSameTheTwoFormsOfHR() {
        this.theseAreConsideredTheSame("a <hr><hr/>\n b", "a <hr/>\n<hr> b");
    }

    @Test
    public void treatsTheSameTheTwoFormsOfBR() {
        this.theseAreConsideredTheSame("a <br><br/> b", "a <br/><br> b");
    }

    @Test
    public void treatsTheSameWhenExpectedIsIGNORE() {
        this.theseAreConsideredTheSame("a <br><br/> b", "IGNORE");
    }

    @Test
    public void treatsTheSameWhenTextAfterStacktraceIsIgnored() {
        this.theseAreConsideredTheSame("ab class=\"fit_stacktrace\"> XYZ", "ab class=\"fit_stacktrace\">");
    }

    private void theseAreConsideredTheSame(String string, String string2) {
        final Table table = this.specifyingTable(TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell(string))), TableBuilderForTests.cell("").with(this.singleRowTable(TableBuilderForTests.cell(string2))));
        this.storytestRunnerIsCalled(table);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Cell)this.oneOf(TestSpecifyFixture.this.expectedCell(table))).pass(TestSpecifyFixture.this.testResults);
                ((TestResults)this.oneOf(TestSpecifyFixture.this.testResults)).addRights(0);
            }
        });
        this.specifyFixture.interpretAfterFirstRow(table, this.testResults);
    }

    protected Cell actualCell(Table table) {
        return (Cell)((Row)table.at(1)).at(0);
    }

    protected Cell expectedCell(Table table) {
        return (Cell)((Row)table.at(1)).at(1);
    }

    private Table specifyingTable(TableBuilderForTests.CellBuilder cellBuilder, TableBuilderForTests.CellBuilder cellBuilder2) {
        return (Table)TableBuilderForTests.table().with(TableBuilderForTests.row(), TableBuilderForTests.row().with(cellBuilder, cellBuilder2)).mock(this.context);
    }

    private TableBuilderForTests.TableBuilder singleRowTable(TableBuilderForTests.CellBuilder ... cellBuilderArray) {
        return TableBuilderForTests.table().with(TableBuilderForTests.row().with(cellBuilderArray));
    }

    private void storytestRunnerIsCalled(final Table table) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((StorytestRunner)this.oneOf(TestSpecifyFixture.this.runner)).doStorytest((Tables)((Row)table.at(1)).at(0));
            }
        });
    }
}

