/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec.filter;

import fitlibrary.spec.PipeLine;
import fitlibrary.spec.filter.StackTraceFilter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestStackTraceFilter {
    final Mockery context = new Mockery();
    final PipeLine pipeline = (PipeLine)this.context.mock(PipeLine.class);
    final StackTraceFilter filter = new StackTraceFilter(this.pipeline);

    @Test
    public void noAffectWhenBothEmpty() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestStackTraceFilter.this.pipeline)).match("", "");
                this.will(1.returnValue((Object)true));
            }
        });
        this.filter.match("", "");
    }

    @Test
    public void noAffectWhenNoStackTrace() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestStackTraceFilter.this.pipeline)).match("ab", "ab");
                this.will(2.returnValue((Object)true));
            }
        });
        this.filter.match("ab", "ab");
    }

    @Test
    public void whenStackTraceOnlyInActual() {
        MatcherAssert.assertThat((Object)this.filter.match("abclass=\"fit_stacktrace\">ABC", "abcd"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void whenStackTraceOnlyInExpected() {
        MatcherAssert.assertThat((Object)this.filter.match("abcd", "abclass=\"fit_stacktrace\">ABC"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void whenStackTraceInBoth() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestStackTraceFilter.this.pipeline)).match("ab", "ab");
                this.will(3.returnValue((Object)true));
            }
        });
        MatcherAssert.assertThat((Object)this.filter.match("abclass=\"fit_stacktrace\">ABC", "abclass=\"fit_stacktrace\">OTHER STUFF"), (Matcher)CoreMatchers.is((Object)true));
    }
}

