/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.spec.matcher;

import fitlibrary.spec.PipeLine;
import fitlibrary.spec.matcher.ImageSrcMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestImageSrcMatcher {
    final Mockery context = new Mockery();
    final PipeLine pipeline = (PipeLine)this.context.mock(PipeLine.class);
    final ImageSrcMatcher matcher = new ImageSrcMatcher(this.pipeline);

    @Test
    public void noAffectWhenNoFitLabel() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestImageSrcMatcher.this.pipeline)).match("ab", "ab");
                this.will(1.returnValue((Object)true));
            }
        });
        this.matcher.match("ab", "ab");
    }

    @Test
    public void failsWhenImageOnlyInActual() {
        MatcherAssert.assertThat((Object)this.matcher.match("ab<img src=\"files/image.jpg>cd", "abcd"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void failsWhenImageOnlyInExpected() {
        MatcherAssert.assertThat((Object)this.matcher.match("abcd", "ab<img src=\"files/image.jpg>cd"), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void passesWhenFitLabelSame() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestImageSrcMatcher.this.pipeline)).match("ab", "ab");
                this.will(2.returnValue((Object)true));
                ((PipeLine)this.oneOf(TestImageSrcMatcher.this.pipeline)).match("cd", "cd");
                this.will(2.returnValue((Object)true));
            }
        });
        MatcherAssert.assertThat((Object)this.matcher.match("ab<img src=\"files/image.jpg>cd", "ab<img src=\"files/image.jpg>cd"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenActualImageEndsTheSame() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestImageSrcMatcher.this.pipeline)).match("ab", "ab");
                this.will(3.returnValue((Object)true));
                ((PipeLine)this.oneOf(TestImageSrcMatcher.this.pipeline)).match("cd", "cd");
                this.will(3.returnValue((Object)true));
            }
        });
        MatcherAssert.assertThat((Object)this.matcher.match("ab<img src=\"OTHER-STUFF/files/image.jpg>cd", "ab<img src=\"files/image.jpg>cd"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void whenActualFitLabelDoesNotEndTheSame() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PipeLine)this.oneOf(TestImageSrcMatcher.this.pipeline)).match("ab", "ab");
                this.will(4.returnValue((Object)true));
            }
        });
        MatcherAssert.assertThat((Object)this.matcher.match("ab<img src=\"OTHER-STUFF/files/image.gif>cd", "ab<img src=\"files/image.jpg>cd"), (Matcher)CoreMatchers.is((Object)false));
    }
}

