/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.matcher.TableBuilderForTests;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.CellOnList;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.table.Tables;
import fitlibrary.utility.StringTablesPair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestCellOnList {
    Mockery context = new Mockery();
    VariableResolver resolver = (VariableResolver)this.context.mock(VariableResolver.class);
    TestResults testResults = (TestResults)this.context.mock(TestResults.class);
    final Table table0 = (Table)TableBuilderForTests.table().mock(this.context, "", 0);
    final Table table1 = (Table)TableBuilderForTests.table().mock(this.context, "", 1);
    final Cell cellA = new CellOnList("AbC");
    final Cell cellXml = new CellOnList("Ab<x/><y><z/></y>C");
    final Cell cellVar = new CellOnList("@{a}");

    @Before
    public void useListsFactory() {
        TableFactory.useOnLists(true);
    }

    @After
    public void stopUsingListsFactory() {
        TableFactory.pop();
    }

    @Test
    public void text() {
        MatcherAssert.assertThat((Object)this.cellA.text(), (Matcher)CoreMatchers.is((Object)"AbC"));
    }

    @Test
    public void textWithResolver() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(1.returnValue((Object)new StringTablesPair("AbCD")));
            }
        });
        MatcherAssert.assertThat((Object)this.cellA.text(this.resolver), (Matcher)CoreMatchers.is((Object)"AbCD"));
    }

    @Test
    public void textLower() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(2.returnValue((Object)new StringTablesPair("AbCD")));
            }
        });
        MatcherAssert.assertThat((Object)this.cellA.textLower(this.resolver), (Matcher)CoreMatchers.is((Object)"abcd"));
    }

    @Test
    public void fullText() {
        MatcherAssert.assertThat((Object)this.cellXml.fullText(), (Matcher)CoreMatchers.is((Object)"Ab<x/><y><z/></y>C"));
        MatcherAssert.assertThat((Object)this.cellXml.text(), (Matcher)CoreMatchers.is((Object)"AbC"));
    }

    @Test
    public void setText() {
        this.cellA.setText("xy<a/>z");
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"xy<a/>z"));
        MatcherAssert.assertThat((Object)this.cellA.text(), (Matcher)CoreMatchers.is((Object)"xyz"));
    }

    @Test
    public void setUnvisitedEscapedText() {
        this.cellA.setUnvisitedEscapedText("xyz");
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)" <span class=\"fit_grey\">xyz</span>"));
        MatcherAssert.assertThat((Object)this.cellA.text(), (Matcher)CoreMatchers.is((Object)"xyz"));
    }

    @Test
    public void isBlank() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(3.returnValue((Object)new StringTablesPair("")));
            }
        });
        MatcherAssert.assertThat((Object)this.cellA.isBlank(this.resolver), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void isNotBlank() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(4.returnValue((Object)new StringTablesPair("AbC")));
            }
        });
        MatcherAssert.assertThat((Object)this.cellA.isBlank(this.resolver), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void matchesTextInLowerCase() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(5.returnValue((Object)new StringTablesPair("ABC")));
            }
        });
        MatcherAssert.assertThat((Object)this.cellA.matchesTextInLowerCase("AbC", this.resolver), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void matchesNoTextInLowerCase() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(6.returnValue((Object)new StringTablesPair("AbC")));
            }
        });
        MatcherAssert.assertThat((Object)this.cellA.matchesTextInLowerCase("AC", this.resolver), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void hasNoEmbeddedTables() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.oneOf(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(7.returnValue((Object)new StringTablesPair("AbC")));
            }
        });
        MatcherAssert.assertThat((Object)this.cellA.hasEmbeddedTables(this.resolver), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void hasEmbeddedTables() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(8.returnValue((Object)new StringTablesPair("AbC")));
            }
        });
        this.cellA.add(this.table0);
        MatcherAssert.assertThat((Object)this.cellA.hasEmbeddedTables(this.resolver), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void hasEmbeddedTablesAfterResolving() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(9.returnValue((Object)new StringTablesPair("AbC", TableFactory.tables(TestCellOnList.this.table0))));
            }
        });
        MatcherAssert.assertThat((Object)this.cellA.hasEmbeddedTables(this.resolver), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void getNoEmbeddedTables() {
        MatcherAssert.assertThat((Object)this.cellA.getEmbeddedTables().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void getEmbeddedTables() {
        this.cellA.add(this.table0);
        Tables tables = this.cellA.getEmbeddedTables();
        MatcherAssert.assertThat((Object)tables.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(tables.at(0), (Matcher)CoreMatchers.is((Object)this.table0));
    }

    @Test
    public void setInnerTables() {
        this.cellA.setInnerTables(TableFactory.tables(this.table0));
        Tables tables = this.cellA.getEmbeddedTables();
        MatcherAssert.assertThat((Object)tables.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(tables.at(0), (Matcher)CoreMatchers.is((Object)this.table0));
    }

    @Test
    public void pass() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).pass();
            }
        });
        this.cellA.pass(this.testResults);
        MatcherAssert.assertThat((Object)this.cellA.didPass(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void passOrFailPasses() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).pass();
            }
        });
        this.cellA.passOrFail(this.testResults, true);
        MatcherAssert.assertThat((Object)this.cellA.didPass(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void passOrFailFails() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.passOrFail(this.testResults, false);
        MatcherAssert.assertThat((Object)this.cellA.didPass(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void passWitMsg() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).pass();
            }
        });
        this.cellA.pass(this.testResults, "msg");
        MatcherAssert.assertThat((Object)this.cellA.didPass(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC<hr>msg <span class=\"fit_label\">actual</span>"));
    }

    @Test
    public void passIfNotEmbedded() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(14.returnValue((Object)new StringTablesPair("AbC")));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).pass();
            }
        });
        this.cellA.passIfNotEmbedded(this.testResults, this.resolver);
        MatcherAssert.assertThat((Object)this.cellA.didPass(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void passIfNotEmbeddedFails() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(15.returnValue((Object)new StringTablesPair("AbC")));
            }
        });
        this.cellA.add(this.table0);
        this.cellA.passIfNotEmbedded(this.testResults, this.resolver);
        MatcherAssert.assertThat((Object)this.cellA.didPass(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void passIfBlank() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(16.returnValue((Object)new StringTablesPair("")));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).pass();
            }
        });
        this.cellA.passOrFailIfBlank(this.testResults, this.resolver);
        MatcherAssert.assertThat((Object)this.cellA.didPass(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void passOrFailIfBlankFails() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(17.returnValue((Object)new StringTablesPair("AbC")));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.passOrFailIfBlank(this.testResults, this.resolver);
        MatcherAssert.assertThat((Object)this.cellA.didPass(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void fail() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.fail(this.testResults);
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void failWithMsg() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(19.returnValue((Object)new StringTablesPair("AbC")));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.fail(this.testResults, "msg", this.resolver);
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC <span class=\"fit_label\">expected</span><hr>msg <span class=\"fit_label\">actual</span>"));
    }

    @Test
    public void failWithStringEquals() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(20.returnValue((Object)new StringTablesPair("AbC")));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.failWithStringEquals(this.testResults, "msg", this.resolver);
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC <span class=\"fit_label\">expected</span><hr>msg <span class=\"fit_label\">actual</span>"));
    }

    @Test
    public void failHtml() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(21.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.failHtml(this.testResults, "<i>msg</i>");
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC<i>msg</i>"));
    }

    @Test
    public void wrongHtml() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(22.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.wrongHtml(this.testResults, "<i>msg</i>");
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC <span class=\"fit_label\">expected</span><hr><i>msg</i> <span class=\"fit_label\">actual</span>"));
    }

    @Test
    public void expectedElementMissing() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(23.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.expectedElementMissing(this.testResults);
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC <span class=\"fit_label\">missing</span>"));
    }

    @Test
    public void actualElementMissing() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(24.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.actualElementMissing(this.testResults);
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC <span class=\"fit_label\">surplus</span>"));
    }

    @Test
    public void actualElementMissingWithMsg() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(25.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.actualElementMissing(this.testResults, "msg");
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)" <span class=\"fit_grey\">msg</span> <span class=\"fit_label\">surplus</span>"));
    }

    @Test
    public void unexpected() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(26.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).fail();
            }
        });
        this.cellA.unexpected(this.testResults, "msg");
        MatcherAssert.assertThat((Object)this.cellA.didFail(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC <span class=\"fit_label\">unexpected msg</span>"));
    }

    @Test
    public void exceptionExpectedNot() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(27.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).exception();
            }
        });
        this.cellA.exceptionExpected(false, new FitLibraryException("AA"), this.testResults);
        MatcherAssert.assertThat((Object)this.cellA.hadError(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC<hr/> <span class=\"fit_label\">AA</span>"));
    }

    @Test
    public void exceptionExpected() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(28.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).pass();
            }
        });
        this.cellA.exceptionExpected(true, new FitLibraryException("AA"), this.testResults);
        MatcherAssert.assertThat((Object)this.cellA.didPass(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC"));
    }

    @Test
    public void error() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(29.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).exception();
            }
        });
        this.cellA.error(this.testResults);
        MatcherAssert.assertThat((Object)this.cellA.hadError(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC"));
    }

    @Test
    public void errorWithMessage() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(30.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).exception();
            }
        });
        this.cellA.error(this.testResults, "msg");
        MatcherAssert.assertThat((Object)this.cellA.hadError(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC<hr/> <span class=\"fit_label\">msg</span>"));
    }

    @Test
    public void ignore() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("AbC");
                this.will(31.returnValue((Object)"AbC"));
                ((TestResults)this.oneOf(TestCellOnList.this.testResults)).ignore();
            }
        });
        this.cellA.ignore(this.testResults);
        MatcherAssert.assertThat((Object)this.cellA.wasIgnored(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.cellA.fullText(), (Matcher)CoreMatchers.is((Object)"AbC"));
    }

    @Test
    public void unresolved() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("@{a}");
                this.will(32.returnValue((Object)new StringTablesPair("@{a}")));
            }
        });
        MatcherAssert.assertThat((Object)this.cellVar.unresolved(this.resolver), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void resolved() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((VariableResolver)this.allowing(TestCellOnList.this.resolver)).resolve("@{a}");
                this.will(33.returnValue((Object)new StringTablesPair("A")));
            }
        });
        MatcherAssert.assertThat((Object)this.cellVar.unresolved(this.resolver), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void deepCopy() {
        final Table table = (Table)TableBuilderForTests.table().mock(this.context, "", 55);
        final Table table2 = (Table)TableBuilderForTests.table().mock(this.context, "", 66);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.oneOf(TestCellOnList.this.table0)).deepCopy();
                this.will(34.returnValue((Object)table));
                ((Table)this.oneOf(TestCellOnList.this.table1)).deepCopy();
                this.will(34.returnValue((Object)table2));
            }
        });
        this.cellA.setLeader("LL");
        this.cellA.setTrailer("TT");
        this.cellA.add(this.table0);
        this.cellA.add(this.table1);
        Cell cell = (Cell)this.cellA.deepCopy();
        MatcherAssert.assertThat((Object)cell.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(cell.at(0), (Matcher)CoreMatchers.is((Object)table));
        MatcherAssert.assertThat(cell.at(1), (Matcher)CoreMatchers.is((Object)table2));
        MatcherAssert.assertThat((Object)cell.fullText(), (Matcher)CoreMatchers.is((Object)this.cellA.fullText()));
        MatcherAssert.assertThat((Object)cell.getLeader(), (Matcher)CoreMatchers.is((Object)"LL"));
        MatcherAssert.assertThat((Object)cell.getTrailer(), (Matcher)CoreMatchers.is((Object)"TT"));
    }

    @Test
    public void elementAddedToEmptyCell() {
        this.cellA.add(this.table0);
        MatcherAssert.assertThat((Object)this.cellA.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(this.cellA.at(0), (Matcher)CoreMatchers.is((Object)this.table0));
    }

    @Test
    public void elementAddedToCellWithEmbedded() {
        this.cellA.add(this.table0);
        this.cellA.add(this.table1);
        MatcherAssert.assertThat((Object)this.cellA.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(this.cellA.at(0), (Matcher)CoreMatchers.is((Object)this.table0));
        MatcherAssert.assertThat(this.cellA.at(1), (Matcher)CoreMatchers.is((Object)this.table1));
    }

    @Test
    public void toHtml() {
        StringBuilder stringBuilder = new StringBuilder();
        this.cellA.setLeader("LL");
        this.cellA.setTrailer("TT");
        this.cellA.toHtml(stringBuilder);
        MatcherAssert.assertThat((Object)stringBuilder.toString(), (Matcher)CoreMatchers.is((Object)"LL<td>AbC</td>TT"));
    }

    @Test
    public void toHtmlWithElements() {
        final StringBuilder stringBuilder = new StringBuilder();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Table)this.oneOf(TestCellOnList.this.table0)).toHtml(stringBuilder);
                ((Table)this.oneOf(TestCellOnList.this.table1)).toHtml(stringBuilder);
            }
        });
        this.cellA.add(this.table0);
        this.cellA.add(this.table1);
        this.cellA.toHtml(stringBuilder);
        MatcherAssert.assertThat((Object)stringBuilder.toString(), (Matcher)CoreMatchers.is((Object)"<td>AbC</td>"));
    }

    @Test
    public void toHtmlWithPass() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.allowing(TestCellOnList.this.testResults)).pass();
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        this.cellA.pass(this.testResults);
        this.cellA.toHtml(stringBuilder);
        MatcherAssert.assertThat((Object)stringBuilder.toString(), (Matcher)CoreMatchers.is((Object)"<td class=\"pass\">AbC</td>"));
    }

    @Test
    public void toHtmlWithFail() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.allowing(TestCellOnList.this.testResults)).fail();
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        this.cellA.fail(this.testResults);
        this.cellA.toHtml(stringBuilder);
        MatcherAssert.assertThat((Object)stringBuilder.toString(), (Matcher)CoreMatchers.is((Object)"<td class=\"fail\">AbC</td>"));
    }

    @Test
    public void withPreamble() {
        CellOnList cellOnList = new CellOnList(TableFactory.tables(TableFactory.table()));
        cellOnList.addPrefixToFirstInnerTable("preamble");
        MatcherAssert.assertThat((Object)((Table)cellOnList.at(0)).getLeader(), (Matcher)CoreMatchers.is((Object)" <span class=\"fit_label\">preamble</span>"));
        MatcherAssert.assertThat((Object)cellOnList.toString(), (Matcher)CoreMatchers.is((Object)"<td> <span class=\"fit_label\">preamble</span><table border=\"1\" cellspacing=\"0\"></table></td>"));
    }
}

