/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.table;

import fitlibrary.dynamicVariable.VariableResolver;
import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.FitLibraryShowException;
import fitlibrary.matcher.TableBuilderForTests;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.RowOnList;
import fitlibrary.table.TableFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestRowOnListWithTestResults {
    Mockery context = new Mockery();
    TestResults testResults = (TestResults)this.context.mock(TestResults.class);
    VariableResolver resolver = (VariableResolver)this.context.mock(VariableResolver.class);
    Cell cell0 = TableBuilderForTests.cell("0").mock(this.context, "", 0);
    Cell cell1 = TableBuilderForTests.cell("1").mock(this.context, "", 1);
    Cell cell2 = TableBuilderForTests.cell("2").mock(this.context, "", 2);
    Row row12 = TestRowOnListWithTestResults.row(this.cell0, this.cell1);
    Row row123 = TestRowOnListWithTestResults.row(this.cell0, this.cell1, this.cell2);

    @Before
    public void useListsFactory() {
        TableFactory.useOnLists(true);
    }

    @After
    public void stopUsingListsFactory() {
        TableFactory.pop();
    }

    @Test
    public void text() {
        MatcherAssert.assertThat((Object)this.row12.text(1, this.resolver), (Matcher)CoreMatchers.is((Object)"1"));
    }

    @Test
    public void pass() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestRowOnListWithTestResults.this.testResults)).pass();
            }
        });
        this.row12.pass(this.testResults);
        MatcherAssert.assertThat((Object)this.row12.didPass(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void fail() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((TestResults)this.oneOf(TestRowOnListWithTestResults.this.testResults)).fail();
            }
        });
        this.row12.fail(this.testResults);
        MatcherAssert.assertThat((Object)this.row12.didFail(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void error() {
        final FitLibraryException fitLibraryException = new FitLibraryException("aa");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Cell)this.oneOf(TestRowOnListWithTestResults.this.cell0)).error(TestRowOnListWithTestResults.this.testResults, fitLibraryException);
            }
        });
        this.row12.error(this.testResults, fitLibraryException);
    }

    @Test
    public void handleShow() {
        this.row12.error(this.testResults, new FitLibraryShowException(new FitLibraryShowException.Show("SHoW")));
        MatcherAssert.assertThat((Object)this.row12.size(), (Matcher)CoreMatchers.is((Object)3));
        MatcherAssert.assertThat((Object)((Cell)this.row12.at(2)).text(), (Matcher)CoreMatchers.is((Object)"SHoW"));
    }

    @Test
    public void missing() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Cell)this.oneOf(TestRowOnListWithTestResults.this.cell0)).expectedElementMissing(TestRowOnListWithTestResults.this.testResults);
            }
        });
        this.row12.missing(this.testResults);
    }

    @Test
    public void ignore() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Cell)this.oneOf(TestRowOnListWithTestResults.this.cell0)).ignore(TestRowOnListWithTestResults.this.testResults);
                ((Cell)this.oneOf(TestRowOnListWithTestResults.this.cell1)).ignore(TestRowOnListWithTestResults.this.testResults);
            }
        });
        this.row12.ignore(this.testResults);
    }

    @Test
    public void passKeywords() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Cell)this.oneOf(TestRowOnListWithTestResults.this.cell0)).pass(TestRowOnListWithTestResults.this.testResults);
                ((Cell)this.oneOf(TestRowOnListWithTestResults.this.cell2)).pass(TestRowOnListWithTestResults.this.testResults);
            }
        });
        this.row123.passKeywords(this.testResults);
    }

    @Test
    public void deepCopy() {
        final Cell cell = TableBuilderForTests.cell().mock(this.context, "", 55);
        final Cell cell2 = TableBuilderForTests.cell().mock(this.context, "", 66);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Cell)this.oneOf(TestRowOnListWithTestResults.this.cell0)).deepCopy();
                this.will(7.returnValue((Object)cell));
                ((Cell)this.oneOf(TestRowOnListWithTestResults.this.cell1)).deepCopy();
                this.will(7.returnValue((Object)cell2));
            }
        });
        this.row12.setLeader("LL");
        this.row12.setTrailer("TT");
        Row row = (Row)this.row12.deepCopy();
        MatcherAssert.assertThat((Object)row.size(), (Matcher)CoreMatchers.is((Object)2));
        MatcherAssert.assertThat(row.at(0), (Matcher)CoreMatchers.is((Object)cell));
        MatcherAssert.assertThat(row.at(1), (Matcher)CoreMatchers.is((Object)cell2));
        MatcherAssert.assertThat((Object)row.getLeader(), (Matcher)CoreMatchers.is((Object)"LL"));
        MatcherAssert.assertThat((Object)row.getTrailer(), (Matcher)CoreMatchers.is((Object)"TT"));
    }

    @Test
    public void toHtml() {
        final StringBuilder stringBuilder = new StringBuilder();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Cell)this.oneOf(TestRowOnListWithTestResults.this.cell0)).toHtml(stringBuilder);
                ((Cell)this.oneOf(TestRowOnListWithTestResults.this.cell1)).toHtml(stringBuilder);
            }
        });
        this.row12.setLeader("LL");
        this.row12.setTrailer("TT");
        this.row12.toHtml(stringBuilder);
        MatcherAssert.assertThat((Object)stringBuilder.toString(), (Matcher)CoreMatchers.is((Object)"LL<tr></tr>TT"));
    }

    protected static Row row(Cell ... cellArray) {
        RowOnList rowOnList = new RowOnList();
        for (Cell cell : cellArray) {
            rowOnList.add(cell);
        }
        return rowOnList;
    }
}

