/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse;

import fitlibrary.parser.Parser;
import fitlibrary.runResults.TestResults;
import fitlibrary.table.Cell;
import fitlibrary.table.Row;
import fitlibrary.table.Table;
import fitlibrary.table.TableFactory;
import fitlibrary.traverse.Traverse;

public class GridTraverse
extends Traverse {
    private Object[][] grid;
    private Parser parser;

    public GridTraverse(Object sut) {
        super(sut);
    }

    public void setGrid(Object[][] grid) {
        this.grid = grid;
    }

    @Override
    public Object interpretAfterFirstRow(Table table, TestResults testResults) {
        this.parser = GridTraverse.asTyped(this.grid).getComponentTyped().getComponentTyped().parser(this);
        if (this.grid.length == 0 && table.size() == 1) {
            table.pass(testResults);
        } else if (!this.rowsMatch(this.grid, table, testResults)) {
            this.addActualRows(table, this.grid);
        }
        return this.grid;
    }

    private boolean rowsMatch(Object[][] actual, Table table, TestResults testResults) {
        int rowNo;
        boolean matched = true;
        for (rowNo = 0; rowNo < actual.length; ++rowNo) {
            if (!table.atExists(rowNo + 1)) {
                return false;
            }
            Row row = (Row)table.at(rowNo + 1);
            if (this.cellsMatch(actual[rowNo], row, testResults)) continue;
            matched = false;
        }
        for (rowNo = actual.length + 1; rowNo < table.size(); ++rowNo) {
            matched = false;
            ((Row)table.at(rowNo)).fail(testResults);
        }
        return matched;
    }

    private boolean cellsMatch(Object[] actual, Row row, TestResults testResults) {
        boolean matched = true;
        for (int i = 0; i < actual.length; ++i) {
            if (!row.atExists(i)) {
                return false;
            }
            if (this.cellMatches(actual[i], (Cell)row.at(i), testResults)) continue;
            matched = false;
        }
        for (int cellNo = actual.length; cellNo < row.size(); ++cellNo) {
            matched = false;
            ((Cell)row.at(cellNo)).fail(testResults);
        }
        return matched;
    }

    private boolean cellMatches(Object actual, Cell cell, TestResults testResults) {
        boolean matches = false;
        try {
            matches = this.parser.matches(cell, actual, testResults);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (matches) {
            cell.pass(testResults);
        } else {
            cell.fail(testResults);
        }
        return matches;
    }

    private void addActualRows(Table table, Object[][] actual) {
        int i;
        int cols = 0;
        for (Row row : table) {
            cols = Math.max(cols, row.size());
        }
        for (i = 0; i < actual.length; ++i) {
            cols = Math.max(cols, actual[i].length);
        }
        table.newRow().addCell("<i>Actuals:</i>", cols);
        for (i = 0; i < actual.length; ++i) {
            this.makeRow(table.newRow(), actual[i]);
        }
    }

    private void makeRow(Row row, Object[] actuals) {
        if (actuals.length == 0) {
            throw new RuntimeException("Actuals row empty");
        }
        for (int i = 0; i < actuals.length; ++i) {
            row.add(this.cellWithValue(actuals[i]));
        }
    }

    private Cell cellWithValue(Object object) {
        Cell cell = TableFactory.cell("");
        try {
            cell.setUnvisitedText(this.parser.show(object));
        }
        catch (Exception e) {
            cell.setUnvisitedText(e.toString());
        }
        return cell;
    }
}

