/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow;

import fitlibrary.exception.FitLibraryExceptionInHtml;
import fitlibrary.exception.method.AmbiguousActionException;
import fitlibrary.runResults.TestResults;
import fitlibrary.runtime.RuntimeContextInternal;
import fitlibrary.table.Row;
import fitlibrary.traverse.Evaluator;
import fitlibrary.traverse.workflow.DispatchRowInFlow;
import fitlibrary.traverse.workflow.DoCaller;
import fitlibrary.typed.TypedObject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestDispatchRowInFlow {
    Mockery context = new Mockery();
    Evaluator evaluator = (Evaluator)this.context.mock(Evaluator.class);
    Row row = (Row)this.context.mock(Row.class);
    TestResults testResults = (TestResults)this.context.mock(TestResults.class);
    DoCaller doCaller1 = (DoCaller)this.context.mock(DoCaller.class, "DoCaller#1");
    DoCaller doCaller2 = (DoCaller)this.context.mock(DoCaller.class, "DoCaller#2");
    TypedObject typedObject = (TypedObject)this.context.mock(TypedObject.class);
    RuntimeContextInternal runtime = (RuntimeContextInternal)this.context.mock(RuntimeContextInternal.class);

    @Test
    public void oneMatch() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestDispatchRowInFlow.this.row)).size();
                this.will(1.returnValue((Object)2));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).isValid();
                this.will(1.returnValue((Object)true));
                ((Evaluator)this.allowing(TestDispatchRowInFlow.this.evaluator)).getRuntimeContext();
                this.will(1.returnValue((Object)TestDispatchRowInFlow.this.runtime));
                ((RuntimeContextInternal)this.allowing(TestDispatchRowInFlow.this.runtime)).isAbandoned(TestDispatchRowInFlow.this.testResults);
                this.will(1.returnValue((Object)false));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller1)).ambiguityErrorMessage();
                this.will(1.returnValue((Object)"one"));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller1)).run(TestDispatchRowInFlow.this.row, TestDispatchRowInFlow.this.testResults);
                this.will(1.returnValue((Object)TestDispatchRowInFlow.this.typedObject));
            }
        });
        DispatchRowInFlow dispatchRowInFlow = new DispatchRowInFlow(this.evaluator, false){

            @Override
            protected DoCaller[] createDoCallers(Row row, boolean bl) {
                return new DoCaller[]{TestDispatchRowInFlow.this.doCaller1};
            }
        };
        MatcherAssert.assertThat((Object)dispatchRowInFlow.interpretRow(this.row, this.testResults), (Matcher)CoreMatchers.is((Object)this.typedObject));
    }

    @Test
    public void oneMatchOfSeveral() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestDispatchRowInFlow.this.row)).size();
                this.will(3.returnValue((Object)2));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).isValid();
                this.will(3.returnValue((Object)true));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller2)).isValid();
                this.will(3.returnValue((Object)false));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller2)).isAmbiguous();
                this.will(3.returnValue((Object)false));
                ((Evaluator)this.allowing(TestDispatchRowInFlow.this.evaluator)).getRuntimeContext();
                this.will(3.returnValue((Object)TestDispatchRowInFlow.this.runtime));
                ((RuntimeContextInternal)this.allowing(TestDispatchRowInFlow.this.runtime)).isAbandoned(TestDispatchRowInFlow.this.testResults);
                this.will(3.returnValue((Object)false));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller1)).ambiguityErrorMessage();
                this.will(3.returnValue((Object)"one"));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller1)).run(TestDispatchRowInFlow.this.row, TestDispatchRowInFlow.this.testResults);
                this.will(3.returnValue((Object)TestDispatchRowInFlow.this.typedObject));
            }
        });
        DispatchRowInFlow dispatchRowInFlow = new DispatchRowInFlow(this.evaluator, false){

            @Override
            protected DoCaller[] createDoCallers(Row row, boolean bl) {
                return new DoCaller[]{TestDispatchRowInFlow.this.doCaller1, TestDispatchRowInFlow.this.doCaller2};
            }
        };
        MatcherAssert.assertThat((Object)dispatchRowInFlow.interpretRow(this.row, this.testResults), (Matcher)CoreMatchers.is((Object)this.typedObject));
    }

    @Test
    public void noMatch() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestDispatchRowInFlow.this.row)).size();
                this.will(5.returnValue((Object)2));
                ((Row)this.oneOf(TestDispatchRowInFlow.this.row)).error(TestDispatchRowInFlow.this.testResults, new FitLibraryExceptionInHtml("Missing class or"));
            }
        });
        DispatchRowInFlow dispatchRowInFlow = new DispatchRowInFlow(this.evaluator, false){

            @Override
            protected DoCaller[] createDoCallers(Row row, boolean bl) {
                return new DoCaller[0];
            }
        };
        dispatchRowInFlow.interpretRow(this.row, this.testResults);
    }

    @Test
    public void twoMatchesSoAmbiguous() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestDispatchRowInFlow.this.row)).size();
                this.will(7.returnValue((Object)2));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller1)).isValid();
                this.will(7.returnValue((Object)true));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller2)).isValid();
                this.will(7.returnValue((Object)true));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller1)).ambiguityErrorMessage();
                this.will(7.returnValue((Object)"one"));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller2)).ambiguityErrorMessage();
                this.will(7.returnValue((Object)"two"));
                ((Row)this.oneOf(TestDispatchRowInFlow.this.row)).error(TestDispatchRowInFlow.this.testResults, new AmbiguousActionException("one AND two"));
            }
        });
        DispatchRowInFlow dispatchRowInFlow = new DispatchRowInFlow(this.evaluator, false){

            @Override
            protected DoCaller[] createDoCallers(Row row, boolean bl) {
                return new DoCaller[]{TestDispatchRowInFlow.this.doCaller1, TestDispatchRowInFlow.this.doCaller2};
            }
        };
        dispatchRowInFlow.interpretRow(this.row, this.testResults);
    }

    @Test
    public void oneMatchWhichIsLocallyAmbiguous() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestDispatchRowInFlow.this.row)).size();
                this.will(9.returnValue((Object)2));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller1)).isValid();
                this.will(9.returnValue((Object)false));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller1)).isAmbiguous();
                this.will(9.returnValue((Object)true));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller1)).ambiguityErrorMessage();
                this.will(9.returnValue((Object)"one AND two"));
                ((Row)this.oneOf(TestDispatchRowInFlow.this.row)).error(TestDispatchRowInFlow.this.testResults, new AmbiguousActionException("one AND two"));
            }
        });
        DispatchRowInFlow dispatchRowInFlow = new DispatchRowInFlow(this.evaluator, false){

            @Override
            protected DoCaller[] createDoCallers(Row row, boolean bl) {
                return new DoCaller[]{TestDispatchRowInFlow.this.doCaller1};
            }
        };
        dispatchRowInFlow.interpretRow(this.row, this.testResults);
    }

    @Test
    public void oneMatchOfTwoWhichIsLocallyAmbiguous() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestDispatchRowInFlow.this.row)).size();
                this.will(11.returnValue((Object)2));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).isValid();
                this.will(11.returnValue((Object)false));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).isAmbiguous();
                this.will(11.returnValue((Object)true));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).ambiguityErrorMessage();
                this.will(11.returnValue((Object)"one AND two"));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller2)).isValid();
                this.will(11.returnValue((Object)true));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller2)).ambiguityErrorMessage();
                this.will(11.returnValue((Object)"three"));
                ((Row)this.oneOf(TestDispatchRowInFlow.this.row)).error(TestDispatchRowInFlow.this.testResults, new AmbiguousActionException("one AND two AND three"));
            }
        });
        DispatchRowInFlow dispatchRowInFlow = new DispatchRowInFlow(this.evaluator, false){

            @Override
            protected DoCaller[] createDoCallers(Row row, boolean bl) {
                return new DoCaller[]{TestDispatchRowInFlow.this.doCaller1, TestDispatchRowInFlow.this.doCaller2};
            }
        };
        dispatchRowInFlow.interpretRow(this.row, this.testResults);
    }

    @Test
    public void onePartialError() {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestDispatchRowInFlow.this.row)).size();
                this.will(13.returnValue((Object)2));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).isValid();
                this.will(13.returnValue((Object)false));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).isAmbiguous();
                this.will(13.returnValue((Object)false));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).partiallyValid();
                this.will(13.returnValue((Object)true));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).getPartialErrorMessage();
                this.will(13.returnValue((Object)"one AND two"));
                ((Row)this.oneOf(TestDispatchRowInFlow.this.row)).error(TestDispatchRowInFlow.this.testResults, new FitLibraryExceptionInHtml("one AND two"));
            }
        });
        DispatchRowInFlow dispatchRowInFlow = new DispatchRowInFlow(this.evaluator, false){

            @Override
            protected DoCaller[] createDoCallers(Row row, boolean bl) {
                return new DoCaller[]{TestDispatchRowInFlow.this.doCaller1};
            }
        };
        dispatchRowInFlow.interpretRow(this.row, this.testResults);
    }

    @Test
    public void oneMatchWithProblem() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((Row)this.allowing(TestDispatchRowInFlow.this.row)).size();
                this.will(15.returnValue((Object)2));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).isValid();
                this.will(15.returnValue((Object)false));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).isAmbiguous();
                this.will(15.returnValue((Object)false));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).partiallyValid();
                this.will(15.returnValue((Object)false));
                ((DoCaller)this.allowing(TestDispatchRowInFlow.this.doCaller1)).isProblem();
                this.will(15.returnValue((Object)true));
                ((DoCaller)this.oneOf(TestDispatchRowInFlow.this.doCaller1)).problem();
                this.will(15.returnValue((Object)new RuntimeException("one")));
                ((Row)this.oneOf(TestDispatchRowInFlow.this.row)).error(TestDispatchRowInFlow.this.testResults, new FitLibraryExceptionInHtml("Missing class or Missing method. Possibly:<ul><li>one</li></ul>"));
            }
        });
        DispatchRowInFlow dispatchRowInFlow = new DispatchRowInFlow(this.evaluator, false){

            @Override
            protected DoCaller[] createDoCallers(Row row, boolean bl) {
                return new DoCaller[]{TestDispatchRowInFlow.this.doCaller1};
            }
        };
        dispatchRowInFlow.interpretRow(this.row, this.testResults);
    }
}

