/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.traverse.workflow.special;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.exception.parse.BadNumberException;
import fitlibrary.flow.GlobalActionScope;
import fitlibrary.special.DoAction;
import fitlibrary.tableProxy.CellProxy;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JMock.class)
public class TestRelational {
    Mockery context = new Mockery();
    DoAction action = (DoAction)this.context.mock(DoAction.class);
    CellProxy cellProxy = (CellProxy)this.context.mock(CellProxy.class);
    GlobalActionScope globalActionScope = new GlobalActionScope();

    public void actual(final Object object) throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.oneOf(TestRelational.this.action)).run();
                this.will(1.returnValue((Object)object));
                ((DoAction)this.allowing(TestRelational.this.action)).cellAt(1);
                this.will(1.returnValue((Object)TestRelational.this.cellProxy));
            }
        });
    }

    @Test
    public void lessThanPasses() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).pass();
            }
        });
        this.actual(0);
        this.globalActionScope.lessThan(this.action, 1);
    }

    @Test
    public void lessThanFails() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).fail("100");
            }
        });
        this.actual(100L);
        this.globalActionScope.lessThan(this.action, -1L);
    }

    @Test
    public void lessThanFailsOnEquality() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).fail("100");
            }
        });
        this.actual(100L);
        this.globalActionScope.lessThan(this.action, 100L);
    }

    @Test
    public void lessThanEqualsPasses() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).pass();
            }
        });
        this.actual(0);
        this.globalActionScope.lessThanEquals(this.action, 1);
    }

    @Test
    public void lessThanEqualsPassesOnEquality() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).pass();
            }
        });
        this.actual((byte)5);
        this.globalActionScope.lessThanEquals(this.action, (byte)5);
    }

    @Test
    public void lessThanEqualsThanFails() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).fail("100");
            }
        });
        this.actual(100L);
        this.globalActionScope.lessThanEquals(this.action, -1L);
    }

    @Test
    public void greaterThanPasses() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).pass();
            }
        });
        this.actual("ab");
        this.globalActionScope.greaterThan(this.action, "a");
    }

    @Test
    public void greaterThanFails() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).fail("5");
            }
        });
        this.actual(new Short("5"));
        this.globalActionScope.greaterThan(this.action, new Short("10"));
    }

    @Test
    public void greaterThanFailsOnEquality() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).fail("true");
            }
        });
        this.actual(true);
        this.globalActionScope.greaterThan(this.action, true);
    }

    @Test
    public void greaterThanEqualsPasses() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).pass();
            }
        });
        this.actual(0);
        this.globalActionScope.greaterThanEquals(this.action, -1);
    }

    @Test
    public void greaterThanEqualsPassesOnEquality() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).pass();
            }
        });
        this.actual((byte)5);
        this.globalActionScope.greaterThanEquals(this.action, (byte)5);
    }

    @Test
    public void greaterThanEqualsThanFails() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((CellProxy)this.one(TestRelational.this.cellProxy)).fail("100");
            }
        });
        this.actual(100L);
        this.globalActionScope.greaterThanEquals(this.action, 200L);
    }

    @Test(expected=ClassCastException.class)
    public void valueTypeIncompatibility() throws Exception {
        this.actual(100L);
        this.globalActionScope.lessThan(this.action, -1);
    }

    @Test(expected=FitLibraryException.class)
    public void nullResult() throws Exception {
        this.actual(null);
        this.globalActionScope.lessThan(this.action, -1);
    }

    @Test(expected=FitLibraryException.class)
    public void nullExpected() throws Exception {
        this.globalActionScope.lessThan(this.action, null);
    }

    @Test(expected=FitLibraryException.class)
    public void expectedNotComparable() throws Exception {
        this.globalActionScope.lessThan(this.action, new NotComparable());
    }

    @Test(expected=FitLibraryException.class)
    public void resultNotComparable() throws Exception {
        this.actual(new NotComparable());
        this.globalActionScope.lessThan(this.action, 0);
    }

    @Test(expected=BadNumberException.class)
    public void errorWithException() throws Exception {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DoAction)this.one(TestRelational.this.action)).run();
                this.will(14.throwException((Throwable)new BadNumberException()));
            }
        });
        this.globalActionScope.lessThan(this.action, -1);
    }

    static class NotComparable {
        NotComparable() {
        }
    }
}

