/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.mockWebServices.term;

import fitlibrary.mockWebServices.term.AbstractTerm;
import fitlibrary.mockWebServices.term.Term;
import fitlibrary.ws.logger.Logger;
import java.util.ArrayList;
import java.util.List;

public abstract class CompositeTerm
extends AbstractTerm {
    protected List<Term> terms = new ArrayList<Term>();

    public CompositeTerm(Term ... ts) {
        Term[] termArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            this.add(t);
            ++n2;
        }
    }

    public void add(Term term) {
        this.add(term, true);
    }

    public synchronized void add(Term term, boolean insertAtEnd) {
        if (insertAtEnd) {
            this.terms.add(term);
        } else {
            this.terms.add(0, term);
        }
        term.setComposite(this);
    }

    @Override
    public synchronized boolean available() {
        for (Term term : this.terms) {
            if (!term.available()) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isEmpty() {
        return this.terms.isEmpty();
    }

    @Override
    public synchronized void logUnused(int portNo, Logger logger) {
        for (Term term : this.terms) {
            term.logUnused(portNo, logger);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.terms;
    }
}

