/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.mockWebServices.term;

import fitlibrary.mockWebServices.requestMatcher.RequestMatcher;
import fitlibrary.mockWebServices.responder.ErrorResponder;
import fitlibrary.mockWebServices.responder.Responder;
import fitlibrary.mockWebServices.term.AbstractTerm;
import fitlibrary.ws.logger.Logger;
import fitlibrary.ws.message.HttpMessage;
import java.io.IOException;

public class LeafTerm
extends AbstractTerm {
    private boolean available = true;
    private final RequestMatcher requestMatcher;
    private final Responder responder;

    public LeafTerm(RequestMatcher requestMatcher, Responder responder) {
        this.requestMatcher = requestMatcher;
        this.responder = responder;
    }

    @Override
    public synchronized boolean available() {
        return this.available;
    }

    @Override
    public synchronized Responder matchRequest(HttpMessage request) throws IOException {
        if (this.requestMatcher.match(request)) {
            this.available = false;
            return this.responder;
        }
        return ErrorResponder.create();
    }

    @Override
    public synchronized void logUnused(int portNo, Logger logger) {
        if (this.available) {
            logger.unused(portNo, this.requestMatcher.getExpected());
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.requestMatcher.getExpected() + "]";
    }
}

