/*
 * Decompiled with CFR 0.152.
 */
package fitlibrary.sh.utility;

import fitlibrary.exception.FitLibraryException;
import fitlibrary.service.ServicingFixture;
import fitlibrary.sh.utility.QueueLinesFromStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public abstract class InteractiveFixture
extends ServicingFixture {
    protected BufferedWriter sysIn;
    protected QueueLinesFromStream sysOut;

    public String sysOutLine() throws InterruptedException {
        return this.sysOutLine(this.defaultTimeout);
    }

    public String sysOutLine(long timeout) throws InterruptedException {
        if (this.sysOut == null) {
            throw new FitLibraryException("Not connected");
        }
        return this.sysOut.take(timeout, TimeUnit.MILLISECONDS).trim();
    }

    public String firstMatchingLineWithInSysOut(String pattern) throws InterruptedException {
        return this.firstMatchingLineWithSysOutWaitingFor(pattern, this.defaultTimeout);
    }

    public String firstMatchingLineWithSysOutWaitingFor(String pattern, long timeout) throws InterruptedException {
        if (this.sysOut == null) {
            throw new FitLibraryException("Not connected");
        }
        return this.sysOut.findFirstMatchingLineWaitingFor(".*" + pattern + ".*", timeout, TimeUnit.MILLISECONDS);
    }

    public void sleep(int milliseconds) throws InterruptedException {
        Thread.sleep(milliseconds);
    }

    public void writeInput(String s) throws IOException {
        if (this.sysIn == null) {
            throw new FitLibraryException("Not connected");
        }
        this.sysIn.write(String.valueOf(s) + "\n");
    }
}

