/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesse;
import fitnesse.authentication.Authenticator;
import fitnesse.authentication.PromiscuousAuthenticator;
import fitnesse.components.Logger;
import fitnesse.html.HtmlPageFactory;
import fitnesse.responders.ResponderFactory;
import fitnesse.responders.run.RunningTestingTracker;
import fitnesse.responders.run.SocketDealer;
import fitnesse.wiki.WikiPage;
import java.io.File;

public class FitNesseContext {
    public FitNesse fitnesse;
    public int port = 80;
    public String rootPath = ".";
    public String rootDirectoryName = "FitNesseRoot";
    public String rootPagePath = "";
    public String defaultNewPageContent = "!contents -R2 -g -p -f -h";
    public WikiPage root;
    public ResponderFactory responderFactory = new ResponderFactory(this.rootPagePath);
    public Logger logger;
    public SocketDealer socketDealer = new SocketDealer();
    public RunningTestingTracker runningTestingTracker = new RunningTestingTracker();
    public Authenticator authenticator = new PromiscuousAuthenticator();
    public HtmlPageFactory htmlPageFactory = new HtmlPageFactory();
    public static String recentChangesDateFormat = "kk:mm:ss EEE, MMM dd, yyyy";
    public static String rfcCompliantDateFormat = "EEE, d MMM yyyy HH:mm:ss Z";
    public static FitNesseContext globalContext;
    public String testResultsDirectoryName = "testResults";
    public boolean shouldCollectHistory = false;
    public boolean doNotChunk;

    public FitNesseContext() {
        this(null);
    }

    public FitNesseContext(WikiPage root) {
        this.root = root;
    }

    public String toString() {
        String endl = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("\t").append("port:              ").append(this.port).append(endl);
        buffer.append("\t").append("root page:         ").append(this.root).append(endl);
        buffer.append("\t").append("logger:            ").append(this.logger == null ? "none" : this.logger.toString()).append(endl);
        buffer.append("\t").append("authenticator:     ").append(this.authenticator).append(endl);
        buffer.append("\t").append("html page factory: ").append(this.htmlPageFactory).append(endl);
        return buffer.toString();
    }

    public static int getPort() {
        return globalContext != null ? FitNesseContext.globalContext.port : -1;
    }

    public File getTestHistoryDirectory() {
        return new File(String.format("%s/files/%s", this.rootPagePath, this.testResultsDirectoryName));
    }

    public void setRootPagePath() {
        this.rootPagePath = this.rootPath + "/" + this.rootDirectoryName;
    }
}

