/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.http;

import fitnesse.http.Response;
import fitnesse.http.ResponseSender;
import fitnesse.testutil.MockSocket;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.net.Socket;

public class MockResponseSender
implements ResponseSender {
    public MockSocket socket = new MockSocket("Mock");
    protected boolean closed = false;

    @Override
    public void send(byte[] bytes) throws Exception {
        for (int i = 0; i < 1000; ++i) {
            Thread.yield();
        }
        this.socket.getOutputStream().write(bytes);
    }

    @Override
    public synchronized void close() throws Exception {
        this.closed = true;
        this.notifyAll();
    }

    @Override
    public Socket getSocket() throws Exception {
        return this.socket;
    }

    public String sentData() throws Exception {
        return this.socket.getOutput();
    }

    public void doSending(Response response) throws Exception {
        response.readyToSend(this);
        this.waitForClose(10000L);
    }

    public synchronized void waitForClose(long timeoutMillis) throws Exception {
        while (!this.closed && timeoutMillis > 0L) {
            this.wait(100L);
            timeoutMillis -= 100L;
        }
        if (!this.closed) {
            throw new Exception("MockResponseSender could not be closed");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static class OutputStreamSender
    extends MockResponseSender {
        public OutputStreamSender(OutputStream out) {
            this.socket = new MockSocket(new PipedInputStream(), out);
        }

        @Override
        public void doSending(Response response) throws Exception {
            response.readyToSend(this);
            while (!this.closed) {
                Thread.sleep(1000L);
            }
        }
    }
}

