/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.responders.WikiImportProperty;
import fitnesse.responders.WikiImporter;
import fitnesse.responders.WikiImporterClient;
import fitnesse.responders.WikiImporterFactory;
import fitnesse.responders.run.SuiteResponder;
import fitnesse.responders.run.TestEventListener;
import fitnesse.responders.run.TestResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;

public class WikiImportTestEventListener
implements TestEventListener {
    private WikiImporterFactory importerFactory;

    public static void register() {
        TestResponder.registerListener(new WikiImportTestEventListener(new WikiImporterFactory()));
    }

    public WikiImportTestEventListener(WikiImporterFactory importerFactory) {
        this.importerFactory = importerFactory;
    }

    @Override
    public void notifyPreTest(TestResponder testResponder, PageData data) throws Exception {
        TestEventProcessor eventProcessor = testResponder instanceof SuiteResponder ? new SuiteEventProcessor() : new TestEventProcessor();
        eventProcessor.run(testResponder, data);
    }

    private class SuiteEventProcessor
    extends TestEventProcessor {
        private SuiteEventProcessor() {
        }

        @Override
        protected void doUpdating() throws Exception {
            if (!this.importProperty.isRoot()) {
                this.updatePagePassedIn();
            }
            this.wikiImporter.setAutoUpdateSetting(true);
            this.wikiImporter.importWiki(this.wikiPage);
        }
    }

    private class TestEventProcessor
    implements WikiImporterClient {
        private TestResponder testResponder;
        private boolean errorOccured;
        protected WikiImporter wikiImporter;
        protected WikiPage wikiPage;
        protected PageData data;
        protected WikiImportProperty importProperty;

        private TestEventProcessor() {
        }

        public void run(TestResponder testResponder, PageData data) throws Exception {
            this.testResponder = testResponder;
            this.data = data;
            this.importProperty = WikiImportProperty.createFrom(data.getProperties());
            if (this.importProperty != null && this.importProperty.isAutoUpdate()) {
                this.announceImportAttempt(testResponder);
                this.doImport(testResponder, data);
                this.closeAnnouncement(testResponder);
            }
        }

        private void closeAnnouncement(TestResponder testResponder) throws Exception {
            if (testResponder.getResponse().isHtmlFormat()) {
                testResponder.addToResponse("</span>");
            }
        }

        private void announceImportAttempt(TestResponder testResponder) throws Exception {
            if (testResponder.getResponse().isHtmlFormat()) {
                testResponder.addToResponse("<span class=\"meta\">Updating imported content...</span>");
                testResponder.addToResponse("<span class=\"meta\">");
            }
        }

        private void doImport(TestResponder testResponder, PageData data) throws Exception {
            try {
                this.wikiImporter = WikiImportTestEventListener.this.importerFactory.newImporter(this);
                this.wikiImporter.parseUrl(this.importProperty.getSourceUrl());
                this.wikiPage = data.getWikiPage();
                this.doUpdating();
                if (!this.errorOccured) {
                    this.announceDone(testResponder);
                }
            }
            catch (Exception e) {
                this.pageImportError(data.getWikiPage(), e);
            }
        }

        private void announceDone(TestResponder testResponder) throws Exception {
            if (testResponder.getResponse().isHtmlFormat()) {
                testResponder.addToResponse("done");
            }
        }

        protected void doUpdating() throws Exception {
            this.updatePagePassedIn();
        }

        protected void updatePagePassedIn() throws Exception {
            this.wikiImporter.importRemotePageContent(this.wikiPage);
            this.data.setContent(this.wikiPage.getData().getContent());
        }

        @Override
        public void pageImported(WikiPage localPage) throws Exception {
        }

        @Override
        public void pageImportError(WikiPage localPage, Exception e) throws Exception {
            this.errorOccured = true;
            System.out.println("Exception while importing \"local page\": " + localPage.getName() + ", exception: " + e.getMessage());
            if (e.getCause() != null) {
                System.out.println("  cause: " + e.getCause().getMessage());
            }
            e.printStackTrace(System.out);
            this.testResponder.addToResponse(e.toString());
        }
    }
}

