/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.files;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.HtmlElement;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTableListingBuilder;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.html.RawHtml;
import fitnesse.html.TagGroup;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.wiki.WikiPageAction;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import util.FileUtil;

public class DirectoryResponder
implements SecureResponder {
    private String resource;
    private File requestedDirectory;
    private FitNesseContext context;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy, hh:mm a");

    public DirectoryResponder(String resource, File requestedFile) {
        this.resource = resource;
        this.requestedDirectory = requestedFile;
    }

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        this.context = context;
        SimpleResponse simpleResponse = new SimpleResponse();
        if (!this.resource.endsWith("/")) {
            this.setRedirectForDirectory(simpleResponse);
        } else {
            simpleResponse.setContent(this.makeDirectoryListingPage());
        }
        return simpleResponse;
    }

    private void setRedirectForDirectory(Response response) {
        if (!this.resource.startsWith("/")) {
            this.resource = "/" + this.resource;
        }
        response.redirect(this.resource + "/");
    }

    private String makeDirectoryListingPage() throws Exception {
        HtmlPage page = this.context.htmlPageFactory.newPage();
        page.title.use("Files: " + this.resource);
        page.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "/", "Files Section"));
        page.actions.use(this.makeFrontPageLink());
        page.main.use(this.makeRightColumn());
        return page.html();
    }

    private HtmlTag makeFrontPageLink() {
        WikiPageAction action = new WikiPageAction("/FrontPage", "FrontPage");
        action.setQuery(null);
        return HtmlUtil.makeAction(action);
    }

    private String makeRightColumn() throws Exception {
        TagGroup html = new TagGroup();
        html.add(this.addFiles(FileUtil.getDirectoryListing(this.requestedDirectory)));
        html.add(HtmlUtil.HR.html());
        html.add(this.makeUploadForm());
        html.add(this.makeDirectoryForm());
        return html.html();
    }

    private HtmlTag addFiles(File[] files) throws Exception {
        HtmlTableListingBuilder table = new HtmlTableListingBuilder();
        this.makeHeadingRow(table);
        this.addFileRows(files, table);
        return table.getTable();
    }

    private void addFileRows(File[] files, HtmlTableListingBuilder table) throws Exception {
        for (File file : files) {
            HtmlTag nameItem = this.makeLinkToFile(file);
            RawHtml sizeItem = new RawHtml(DirectoryResponder.getSizeString(file));
            RawHtml dateItem = new RawHtml(this.dateFormat.format(new Date(file.lastModified())));
            TagGroup actionItem = new TagGroup();
            actionItem.add(this.makeRenameButton(file.getName()));
            actionItem.add("|");
            actionItem.add(this.makeDeleteButton(file.getName()));
            table.addRow(new HtmlElement[]{nameItem, sizeItem, dateItem, actionItem});
        }
    }

    private void makeHeadingRow(HtmlTableListingBuilder table) throws Exception {
        HtmlTag nameHeading = HtmlUtil.makeSpanTag("caps", "Name");
        HtmlTag sizeHeading = HtmlUtil.makeSpanTag("caps", "Size");
        HtmlTag dateHeading = HtmlUtil.makeSpanTag("caps", "Date");
        HtmlTag actionHeading = HtmlUtil.makeSpanTag("caps", "Action");
        table.addRow(new HtmlTag[]{nameHeading, sizeHeading, dateHeading, actionHeading});
    }

    private HtmlTag makeDeleteButton(String filename) throws Exception {
        return HtmlUtil.makeLink("?responder=deleteConfirmation&filename=" + filename, "Delete");
    }

    private HtmlTag makeRenameButton(String filename) throws Exception {
        return HtmlUtil.makeLink("?responder=renameConfirmation&filename=" + filename, "Rename");
    }

    private HtmlTag makeLinkToFile(File file) {
        String href = file.getName();
        if (file.isDirectory()) {
            href = href + "/";
            HtmlTag image = new HtmlTag("img");
            image.addAttribute("src", "/files/images/folder.gif");
            image.addAttribute("class", "left");
            HtmlTag link = HtmlUtil.makeLink(href, image);
            link.add(file.getName());
            return link;
        }
        return HtmlUtil.makeLink(href, file.getName());
    }

    private HtmlTag makeUploadForm() throws Exception {
        HtmlTag uploadForm = HtmlUtil.makeFormTag("post", "/" + this.resource);
        uploadForm.addAttribute("enctype", "multipart/form-data");
        uploadForm.addAttribute("class", "left");
        uploadForm.add("<!--upload form-->");
        uploadForm.add(HtmlUtil.makeSpanTag("caps", "Upload a file:"));
        uploadForm.add(HtmlUtil.makeInputTag("hidden", "responder", "upload"));
        uploadForm.add(HtmlUtil.BR);
        uploadForm.add(HtmlUtil.makeInputTag("file", "file", ""));
        uploadForm.add(HtmlUtil.BR);
        uploadForm.add(HtmlUtil.makeInputTag("submit", "", "Upload"));
        return uploadForm;
    }

    private HtmlTag makeDirectoryForm() throws Exception {
        HtmlTag dirForm = HtmlUtil.makeFormTag("get", "/" + this.resource);
        dirForm.addAttribute("class", "right");
        dirForm.add(HtmlUtil.makeInputTag("hidden", "responder", "createDir"));
        dirForm.add("<!--create directory form-->");
        dirForm.add(HtmlUtil.makeSpanTag("caps", "Create a directory:"));
        dirForm.add(HtmlUtil.BR);
        dirForm.add(HtmlUtil.makeInputTag("text", "dirname", ""));
        dirForm.add(HtmlUtil.BR);
        dirForm.add(HtmlUtil.makeInputTag("submit", "", "Create"));
        return dirForm;
    }

    public static String getSizeString(File file) {
        if (file.isDirectory()) {
            return "";
        }
        return file.length() + " bytes";
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new AlwaysSecureOperation();
    }
}

