/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.refactoring;

import fitnesse.components.ContentReplacingSearchObserver;
import fitnesse.components.PageFinder;
import fitnesse.components.RegularExpressionWikiPageFinder;
import fitnesse.components.SearchObserver;
import fitnesse.responders.search.ResultResponder;
import fitnesse.wiki.WikiPage;

public class SearchReplaceResponder
extends ResultResponder {
    private PageFinder finder;
    private SearchObserver observer;

    @Override
    protected String getPageFooterInfo(int hits) throws Exception {
        return String.format("Replaced %d matches for your search.", hits);
    }

    @Override
    protected String getTitle() throws Exception {
        return String.format("Replacing matching content \"%s\" with content \"%s\"", this.getSearchString(), this.getReplacementString());
    }

    private String getReplacementString() {
        return (String)this.request.getInput("replacementString");
    }

    private String getSearchString() {
        return (String)this.request.getInput("searchString");
    }

    @Override
    public void hit(WikiPage page) throws Exception {
        this.observer.hit(page);
        super.hit(page);
    }

    @Override
    protected void startSearching() throws Exception {
        super.startSearching();
        String searchString = this.getSearchString();
        String replacementString = this.getReplacementString();
        this.observer = new ContentReplacingSearchObserver(searchString, replacementString);
        this.finder = new RegularExpressionWikiPageFinder(searchString, (SearchObserver)this);
        this.finder.search(this.page);
    }
}

