/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.components.RegularExpressionWikiPageFinder;
import fitnesse.components.SearchObserver;
import fitnesse.components.TitleWikiPageFinder;
import fitnesse.responders.search.ResultResponder;
import java.util.regex.Pattern;

public class SearchResponder
extends ResultResponder {
    private String getSearchString() {
        return (String)this.request.getInput("searchString");
    }

    private String getSearchType() {
        String searchType = (String)this.request.getInput("searchType");
        if ((searchType = searchType.toLowerCase()).indexOf("title") != -1) {
            return "Title";
        }
        return "Content";
    }

    @Override
    protected String getPageFooterInfo(int hits) throws Exception {
        return "Found " + hits + " results for your search.";
    }

    @Override
    protected String getTitle() throws Exception {
        return this.getSearchType() + " Search Results for '" + this.getSearchString() + "'";
    }

    @Override
    protected void startSearching() throws Exception {
        super.startSearching();
        String searchString = this.getSearchString();
        if (!"".equals(searchString)) {
            String searchType = this.getSearchType();
            if ("Title".equals(searchType)) {
                new TitleWikiPageFinder(searchString, this).search(this.root);
            } else {
                Pattern regularExpression = Pattern.compile(searchString, 18);
                new RegularExpressionWikiPageFinder(regularExpression, (SearchObserver)this).search(this.root);
            }
        }
    }

    @Override
    protected boolean shouldRespondWith404() {
        return false;
    }
}

