/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.NameTranslator;
import fitnesse.slim.SlimError;
import fitnesse.slim.StatementExecutorInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import util.ListUtility;

public class Statement {
    private ArrayList<Object> words = new ArrayList();
    private NameTranslator methodNameTranslator;

    public Statement(List<Object> statement, NameTranslator methodNameTranslator) {
        this.methodNameTranslator = methodNameTranslator;
        for (Object word : statement) {
            this.words.add(word);
        }
    }

    public boolean add(Object s) {
        return this.words.add(s);
    }

    public boolean addAll(Collection<Object> objects) {
        return this.words.addAll(objects);
    }

    private boolean operationIs(String operation) {
        return this.getOperation().equalsIgnoreCase(operation);
    }

    public String getOperation() {
        return this.getWord(1);
    }

    private String getWord(int word) {
        try {
            return (String)this.words.get(word);
        }
        catch (Exception e) {
            throw new SlimError(String.format("message:<<MALFORMED_INSTRUCTION %s.>>", this.toString()));
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (Object word : this.words) {
            result.append(word);
            result.append(",");
        }
        int end = result.length() - 1;
        if (result.charAt(end) == ',') {
            result.deleteCharAt(end);
        }
        result.append("]");
        return result.toString();
    }

    public Object execute(StatementExecutorInterface executor) {
        Object retval = this.operationIs("make") ? this.createInstance(executor) : (this.operationIs("import") ? this.addPath(executor) : (this.operationIs("call") ? this.call(executor) : (this.operationIs("callAndAssign") ? this.callAndAssign(executor) : "__EXCEPTION__:" + String.format("message:<<INVALID_STATEMENT: %s.>>", this.getOperation()))));
        return ListUtility.list(this.getWord(0), retval);
    }

    private Object addPath(StatementExecutorInterface caller) {
        return caller.addPath(this.getWord(2));
    }

    private Object createInstance(StatementExecutorInterface caller) {
        String instanceName = this.getWord(2);
        String className = this.getWord(3);
        Object[] args = this.makeArgsArray(4);
        return caller.create(instanceName, className, args);
    }

    private Object call(StatementExecutorInterface caller) {
        return this.callMethodAtIndex(caller, 2);
    }

    private Object callMethodAtIndex(StatementExecutorInterface caller, int methodIndex) {
        String instanceName = this.getWord(methodIndex + 0);
        String methodName = this.methodNameTranslator.translate(this.getWord(methodIndex + 1));
        Object[] args = this.makeArgsArray(methodIndex + 2);
        return caller.call(instanceName, methodName, args);
    }

    private Object[] makeArgsArray(int argsIndex) {
        List<Object> argList = this.words.subList(argsIndex, this.words.size());
        Object[] args = argList.toArray(new Object[argList.size()]);
        return args;
    }

    public Object callAndAssign(StatementExecutorInterface caller) {
        String instanceName = this.getWord(3);
        String methodName = this.methodNameTranslator.translate(this.getWord(4));
        Object[] args = this.makeArgsArray(5);
        return caller.callAndAssign(this.getWord(2), instanceName, methodName, args);
    }
}

