/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim.converters;

import fitnesse.slim.Converter;
import fitnesse.slim.converters.BooleanArrayConverter;
import fitnesse.slim.converters.BooleanConverter;
import fitnesse.slim.converters.CharConverter;
import fitnesse.slim.converters.DateConverter;
import fitnesse.slim.converters.DoubleArrayConverter;
import fitnesse.slim.converters.DoubleConverter;
import fitnesse.slim.converters.IntConverter;
import fitnesse.slim.converters.IntegerArrayConverter;
import fitnesse.slim.converters.ListConverter;
import fitnesse.slim.converters.StringArrayConverter;
import fitnesse.slim.converters.StringConverter;
import fitnesse.slim.converters.VoidConverter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConverterRegistry {
    static Map<Class<?>, Converter> converters = new HashMap();

    protected static void addStandardConverters() {
        ConverterRegistry.addConverter(Void.TYPE, new VoidConverter());
        ConverterRegistry.addConverter(String.class, new StringConverter());
        ConverterRegistry.addConverter(Integer.TYPE, new IntConverter());
        ConverterRegistry.addConverter(Double.TYPE, new DoubleConverter());
        ConverterRegistry.addConverter(Integer.class, new IntConverter());
        ConverterRegistry.addConverter(Double.class, new DoubleConverter());
        ConverterRegistry.addConverter(Character.TYPE, new CharConverter());
        ConverterRegistry.addConverter(Boolean.TYPE, new BooleanConverter());
        ConverterRegistry.addConverter(Boolean.class, new BooleanConverter());
        ConverterRegistry.addConverter(Date.class, new DateConverter());
        ConverterRegistry.addConverter(List.class, new ListConverter());
        ConverterRegistry.addConverter(Integer[].class, new IntegerArrayConverter());
        ConverterRegistry.addConverter(int[].class, new IntegerArrayConverter());
        ConverterRegistry.addConverter(String[].class, new StringArrayConverter());
        ConverterRegistry.addConverter(boolean[].class, new BooleanArrayConverter());
        ConverterRegistry.addConverter(Boolean[].class, new BooleanArrayConverter());
        ConverterRegistry.addConverter(double[].class, new DoubleArrayConverter());
        ConverterRegistry.addConverter(Double[].class, new DoubleArrayConverter());
    }

    public static Converter getConverterForClass(Class<?> clazz) {
        return converters.get(clazz);
    }

    public static void addConverter(Class<?> clazz, Converter converter) {
        converters.put(clazz, converter);
    }

    public static Map<Class<?>, Converter> getConverters() {
        return Collections.unmodifiableMap(converters);
    }

    static {
        ConverterRegistry.addStandardConverters();
    }
}

