/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerDeadEndStrategy;
import fitnesse.wiki.PageData;
import fitnesse.wiki.SymbolicPage;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PageCrawlerImpl
implements PageCrawler {
    private PageCrawlerDeadEndStrategy deadEndStrategy;

    protected PageCrawlerImpl() {
    }

    @Override
    public WikiPage getPage(WikiPage context, WikiPagePath path) throws Exception {
        if (path == null) {
            return null;
        }
        if (this.isRoot(path)) {
            return this.getRoot(context);
        }
        if (path.isEmpty()) {
            return context;
        }
        if (path.isAbsolute()) {
            WikiPagePath relativeToRoot = new WikiPagePath(path);
            relativeToRoot.setPathMode(WikiPagePath.Mode.RELATIVE);
            return this.getPage(this.getRoot(context), relativeToRoot);
        }
        if (path.isBackwardSearchPath()) {
            return this.getSiblingPage(context, path);
        }
        String firstPathElement = path.getFirst();
        WikiPagePath restOfPath = path.getRest();
        WikiPage childPage = context.getChildPage(firstPathElement);
        if (childPage != null) {
            return this.getPage(childPage, restOfPath);
        }
        return this.getPageAfterDeadEnd(context, firstPathElement, restOfPath);
    }

    private boolean isRoot(WikiPagePath path) {
        return path.isAbsolute() && path.isEmpty();
    }

    protected WikiPage getPageAfterDeadEnd(WikiPage context, String first, WikiPagePath rest) throws Exception {
        rest.addNameToFront(first);
        if (this.deadEndStrategy != null) {
            return this.deadEndStrategy.getPageAfterDeadEnd(context, rest, this);
        }
        return null;
    }

    @Override
    public void setDeadEndStrategy(PageCrawlerDeadEndStrategy strategy) {
        this.deadEndStrategy = strategy;
    }

    @Override
    public boolean pageExists(WikiPage context, WikiPagePath path) throws Exception {
        return this.getPage(context, path) != null;
    }

    @Override
    public WikiPagePath getFullPathOfChild(WikiPage parent, WikiPagePath childPath) throws Exception {
        WikiPagePath fullPathOfChild;
        if (childPath.isAbsolute()) {
            fullPathOfChild = childPath.relativePath();
        } else {
            WikiPagePath absolutePathOfParent = new WikiPagePath(parent);
            fullPathOfChild = absolutePathOfParent.append(childPath);
        }
        return fullPathOfChild;
    }

    @Override
    public WikiPagePath getFullPath(WikiPage page) throws Exception {
        return new WikiPagePath(page);
    }

    @Override
    public WikiPage addPage(WikiPage context, WikiPagePath path, String content) throws Exception {
        WikiPage page = this.addPage(context, path);
        if (page != null) {
            PageData data = new PageData(page);
            data.setContent(content);
            page.commit(data);
        }
        return page;
    }

    @Override
    public WikiPage addPage(WikiPage context, WikiPagePath path) throws Exception {
        return this.getOrMakePage(context, path.getNames());
    }

    private WikiPage getOrMakePage(WikiPage context, List<?> namePieces) throws Exception {
        String first = (String)namePieces.get(0);
        List<?> rest = namePieces.subList(1, namePieces.size());
        WikiPage current = context.getChildPage(first) == null ? context.addChildPage(first) : context.getChildPage(first);
        if (rest.size() == 0) {
            return current;
        }
        return this.getOrMakePage(current, rest);
    }

    @Override
    public String getRelativeName(WikiPage base, WikiPage page) throws Exception {
        StringBuffer qualName = new StringBuffer();
        for (WikiPage p = page; !this.isRoot(p) && p != base; p = p.getParent()) {
            if (p != page) {
                qualName.insert(0, ".");
            }
            qualName.insert(0, p.getName());
        }
        return qualName.toString();
    }

    public static WikiPage getClosestInheritedPage(String pageName, WikiPage context) throws Exception {
        LinkedList<WikiPage> ancestors = WikiPageUtil.getAncestorsStartingWith(context);
        for (WikiPage ancestor : ancestors) {
            WikiPage namedPage = ancestor.getChildPage(pageName);
            if (namedPage == null) continue;
            return namedPage;
        }
        return null;
    }

    @Override
    public boolean isRoot(WikiPage page) throws Exception {
        WikiPage parent = page.getParent();
        return parent == null || parent == page;
    }

    @Override
    public WikiPage getRoot(WikiPage page) throws Exception {
        if (this.isRoot(page)) {
            return page;
        }
        return this.getRoot(page.getParent());
    }

    @Override
    public void traverse(WikiPage context, TraversalListener listener) throws Exception {
        if (context.getClass() == SymbolicPage.class) {
            return;
        }
        listener.processPage(context);
        List<WikiPage> children = context.getChildren();
        for (WikiPage wikiPage : children) {
            this.traverse(wikiPage, listener);
        }
    }

    @Override
    public WikiPage getSiblingPage(WikiPage page, WikiPagePath pathRelativeToSibling) throws Exception {
        PageCrawler crawler = page.getPageCrawler();
        if (pathRelativeToSibling.isSubPagePath()) {
            WikiPagePath relativePath = new WikiPagePath(pathRelativeToSibling);
            relativePath.setPathMode(WikiPagePath.Mode.RELATIVE);
            return this.getPage(page, relativePath);
        }
        if (pathRelativeToSibling.isBackwardSearchPath()) {
            String target = pathRelativeToSibling.getFirst();
            WikiPage ancestor = this.findAncestorWithName(page, target);
            if (ancestor != null) {
                return this.getPage(ancestor, pathRelativeToSibling.getRest());
            }
            WikiPagePath absolutePath = new WikiPagePath(pathRelativeToSibling);
            absolutePath.makeAbsolute();
            return this.getPage(crawler.getRoot(page), absolutePath);
        }
        WikiPage parent = page.getParent();
        return this.getPage(parent, pathRelativeToSibling);
    }

    @Override
    public WikiPage findAncestorWithName(WikiPage page, String name) throws Exception {
        WikiPage current = page.getParent();
        while (!this.isRoot(current)) {
            if (current.getName().equals(name)) {
                return current;
            }
            current = current.getParent();
        }
        return null;
    }

    public static List<WikiPage> getAllUncles(String uncleName, WikiPage nephew) throws Exception {
        ArrayList<WikiPage> uncles = new ArrayList<WikiPage>();
        LinkedList<WikiPage> ancestors = WikiPageUtil.getAncestorsStartingWith(nephew);
        for (WikiPage ancestor : ancestors) {
            WikiPage namedPage = ancestor.getChildPage(uncleName);
            if (namedPage == null) continue;
            uncles.add(namedPage);
        }
        return uncles;
    }
}

