/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.WikiPagePath;
import java.util.Iterator;
import java.util.regex.Pattern;

public class PathParser {
    public static final String PATH_SEPARATOR = ".";
    public static final String PATH_PREFIX_CHARS = ".<>^";
    private static final Pattern wikiWordPattern = Pattern.compile("(?:[<>^.])?(?:\\b[A-Z](?:[a-z0-9]+[A-Z][a-z0-9]*)+[.]?)+\\b");
    private WikiPagePath path;

    public static WikiPagePath parse(String pathName) {
        return new PathParser().makePath(pathName);
    }

    private WikiPagePath makePath(String pathName) {
        this.path = new WikiPagePath();
        if (pathName.equals("")) {
            return this.path;
        }
        if (pathName.equals("root") || pathName.equals(PATH_SEPARATOR)) {
            this.path.makeAbsolute();
            return this.path;
        }
        return this.parsePathName(pathName);
    }

    private WikiPagePath parsePathName(String pathName) {
        if (pathName.startsWith(PATH_SEPARATOR)) {
            this.path.makeAbsolute();
            pathName = pathName.substring(1);
        } else if (pathName.startsWith(">") || pathName.startsWith("^")) {
            this.path.setPathMode(WikiPagePath.Mode.SUB_PAGE);
            pathName = pathName.substring(1);
        } else if (pathName.startsWith("<")) {
            this.path.setPathMode(WikiPagePath.Mode.BACKWARD_SEARCH);
            pathName = pathName.substring(1);
        }
        String[] names = pathName.split("\\.");
        for (int i = 0; i < names.length; ++i) {
            String pageName = names[i];
            if (!PathParser.nameIsValid(pageName)) {
                return null;
            }
            this.path.addNameToEnd(pageName);
        }
        return this.path;
    }

    public static boolean isPathPrefix(Character c) {
        return PATH_PREFIX_CHARS.indexOf(c.charValue()) >= 0;
    }

    private static boolean nameIsValid(String name) {
        return wikiWordPattern.matcher(name).matches();
    }

    public static String render(WikiPagePath path) {
        StringBuffer renderedPath = new StringBuffer();
        if (path.isSubPagePath()) {
            renderedPath.append(">");
        } else if (path.isBackwardSearchPath()) {
            renderedPath.append("<");
        } else if (path.isAbsolute()) {
            renderedPath.append(PATH_SEPARATOR);
        }
        Iterator<String> i = path.getNames().iterator();
        if (i.hasNext()) {
            String name = i.next();
            renderedPath.append(name);
        }
        while (i.hasNext()) {
            renderedPath.append(PATH_SEPARATOR).append((Object)i.next());
        }
        return renderedPath.toString();
    }
}

