/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlTag;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.ScanString;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import util.Maybe;

public class Define
extends SymbolType
implements Rule,
Translation {
    public Define() {
        super("Define");
        this.wikiMatcher(new Matcher().startLineOrCell().string("!define"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        if (!parser.isMoveNext(SymbolType.Whitespace)) {
            return Symbol.nothing;
        }
        String name = parser.parseToAsString(SymbolType.Whitespace);
        if (parser.atEnd()) {
            return Symbol.nothing;
        }
        if (!ScanString.isVariableName(name)) {
            return Symbol.nothing;
        }
        Symbol next = parser.moveNext(1);
        SymbolType close = next.closeType();
        if (close == SymbolType.Empty) {
            return Symbol.nothing;
        }
        String valueString = parser.parseToAsString(close);
        if (parser.atEnd()) {
            return Symbol.nothing;
        }
        parser.getPage().putVariable(name, valueString);
        return new Maybe<Symbol>(current.add(name).add(valueString));
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        HtmlTag result = new HtmlTag("span", "variable defined: " + translator.translate(symbol.childAt(0)) + "=" + translator.translate(symbol.childAt(1)));
        result.addAttribute("class", "meta");
        return result.html();
    }
}

