/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;

public abstract class Translator {
    private SourcePage currentPage;

    protected abstract Translation getTranslation(SymbolType var1);

    public SourcePage getPage() {
        return this.currentPage;
    }

    protected Translator(SourcePage currentPage) {
        this.currentPage = currentPage;
    }

    public String translateTree(Symbol syntaxTree) {
        StringBuilder result = new StringBuilder();
        for (Symbol symbol : syntaxTree.getChildren()) {
            result.append(this.translate(symbol));
        }
        return result.toString();
    }

    public String translate(Symbol symbol) {
        if (this.getTranslation(symbol.getType()) != null) {
            return this.getTranslation(symbol.getType()).toTarget(this, symbol);
        }
        StringBuilder result = new StringBuilder(symbol.getContent());
        for (Symbol child : symbol.getChildren()) {
            result.append(this.translate(child));
        }
        return result.toString();
    }

    public String formatMessage(String message) {
        return this.translate(new Symbol(SymbolType.Meta).add(message));
    }
}

