/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.ParsingPage;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.VariableSource;
import util.Maybe;

public class VariableFinder
implements VariableSource {
    private ParsingPage page;

    public VariableFinder(ParsingPage page) {
        this.page = page;
    }

    @Override
    public Maybe<String> findVariable(String name) {
        Maybe<String> result = this.page.getSpecialVariableValue(name);
        if (!result.isNothing()) {
            return result;
        }
        result = this.findVariableInPages(name);
        if (!result.isNothing()) {
            return result;
        }
        String value = System.getenv(name);
        if (value != null) {
            return new Maybe<String>(value);
        }
        value = System.getProperty(name);
        if (value != null) {
            return new Maybe<String>(value);
        }
        return Maybe.noString;
    }

    private Maybe<String> findVariableInPages(String name) {
        Maybe<String> localVariable = this.page.findVariable(name);
        if (!localVariable.isNothing()) {
            return new Maybe<String>(localVariable.getValue());
        }
        return this.lookInParentPages(name);
    }

    private Maybe<String> lookInParentPages(String name) {
        for (SourcePage sourcePage : this.page.getPage().getAncestors()) {
            Maybe<String> result;
            if (!this.page.inCache(sourcePage)) {
                Parser.make(this.page.copyForPage(sourcePage), sourcePage.getContent()).parse();
                this.page.putVariable(sourcePage, "", Maybe.noString);
            }
            if ((result = this.page.findVariable(sourcePage, name)).isNothing()) continue;
            return result;
        }
        return Maybe.noString;
    }
}

