/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HeaderWidget
extends ParentWidget {
    public static final String REGEXP = "^![1-6] [^\r\n]*(?:(?:\r\n)|\n|\r)?";
    private static final Pattern pattern = Pattern.compile("!([1-6]) (.*)");
    private int size = 3;

    public HeaderWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.size = Integer.valueOf(match.group(1));
            this.addChildWidgets(match.group(2).trim());
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public String render() throws Exception {
        StringBuffer html = new StringBuffer("<h");
        html.append(this.size).append(">").append(this.childHtml());
        html.append("</h").append(this.size).append(">");
        return html.toString();
    }
}

