/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.widgets.ListItemWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ListWidget
extends ParentWidget {
    public static final String REGEXP = "(?:^[ \\t]+[\\*\\d][^\n]*\n?)+";
    private static final Pattern pattern = Pattern.compile("([ \\t]+)([\\*\\d])([^\n]*)");
    private boolean ordered = false;
    private int level;

    public ListWidget(ParentWidget parent, String text) throws Exception {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.level = this.findLevel(match);
            this.ordered = !"*".equals(match.group(2));
        }
        this.buildList(text);
    }

    private ListWidget(ParentWidget parent, Matcher match) {
        super(parent);
        this.level = this.findLevel(match);
        this.ordered = !"*".equals(match.group(2));
    }

    private String buildList(String text) throws Exception {
        if (text == null) {
            return null;
        }
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            int level = this.findLevel(match);
            if (level > this.level) {
                ListWidget childList = new ListWidget((ParentWidget)this, match);
                String remainder = childList.buildList(text);
                return this.buildList(remainder);
            }
            if (level < this.level) {
                return text;
            }
            String listItemContent = match.group(3).trim();
            Pattern nextPattern = Pattern.compile("([\\r\\n]+" + match.group(1) + "[\\*\\d])");
            Matcher nextMatch = nextPattern.matcher(text.substring(match.end()));
            String childItems = nextMatch.find() ? text.substring(match.end()).substring(0, nextMatch.start()).replaceAll("(^[\\r\\n]+)|([ \\r\\n]+$)", "") : text.substring(match.end()).replaceAll("(^[\\r\\n]+)|( [\\r\\n]+$)", "");
            ListItemWidget item = new ListItemWidget(this, listItemContent, this.level + 1);
            if (!childItems.isEmpty()) {
                new ListWidget((ParentWidget)item, childItems);
            }
            return this.buildList(text.substring(match.end() + childItems.length()));
        }
        return null;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public String render() throws Exception {
        String tagValue = this.ordered ? "ol" : "ul";
        StringBuffer html = new StringBuffer();
        html.append("<").append(tagValue).append(">").append("\n");
        html.append(this.childHtml());
        html.append("</").append(tagValue).append(">").append("\n");
        return html.toString();
    }

    private void appendTabs(StringBuffer html) {
        for (int i = 0; i < this.level; ++i) {
            html.append("\t");
        }
    }

    private int findLevel(Matcher match) {
        return match.group(1).length() - 1;
    }
}

