/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.wikitext.Utils;
import fitnesse.wikitext.WikiWidget;
import fitnesse.wikitext.widgets.ParentWidget;
import fitnesse.wikitext.widgets.WidgetWithTextArgument;

public class TextWidget
extends WikiWidget
implements WidgetWithTextArgument {
    private String text;

    public TextWidget(ParentWidget parent) {
        super(parent);
    }

    public TextWidget(ParentWidget parent, String text) {
        super(parent);
        this.setText(text);
    }

    @Override
    public String getText() {
        return Utils.unescapeWiki(this.text);
    }

    public void setText(String newText) {
        this.text = newText;
    }

    @Override
    public String render() throws Exception {
        String html = this.getText();
        if (this.parent.doEscaping()) {
            html = Utils.escapeHTML(html);
        }
        html = html.replaceAll("\r\n", "\n");
        html = html.replaceAll("\r", "\n");
        html = html.replaceAll("\n", "<br/>");
        return html;
    }

    public String toString() {
        return super.toString() + " : " + this.getText();
    }

    @Override
    public String asWikiText() throws Exception {
        return this.text;
    }

    public String getRawText() {
        return this.text;
    }
}

