/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.widgets;

import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.widgets.ParentWidget;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VariableWidget
extends ParentWidget {
    public static final String prefix = "\\$\\{";
    public static final String REGEXP = "\\$\\{[\\w\\.]+\\}";
    public static final Pattern pattern = Pattern.compile("\\$\\{([\\w\\.]+)\\}", 40);
    public static final String prefixDisabled = "!\\{";
    private String name = null;
    private String renderedText;
    private boolean rendered;

    public VariableWidget(ParentWidget parent, String text) {
        super(parent);
        Matcher match = pattern.matcher(text);
        if (match.find()) {
            this.name = match.group(1);
        }
    }

    @Override
    public String render() throws Exception {
        if (!this.rendered) {
            this.doRender();
        }
        return this.renderedText;
    }

    private void doRender() throws Exception {
        String value = this.parent.getVariable(this.name);
        if (value != null) {
            this.addChildWidgets(value);
            this.renderedText = this.childHtml();
        } else {
            this.renderedText = this.makeUndefinedVariableExpression(this.name);
        }
        this.rendered = true;
    }

    private String makeUndefinedVariableExpression(String name) throws Exception {
        return HtmlUtil.metaText("undefined variable: " + name);
    }

    @Override
    public String asWikiText() throws Exception {
        return "${" + this.name + "}";
    }
}

