/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.IOException;
import util.FileSystem;
import util.FileUtil;

public class DiskFileSystem
implements FileSystem {
    @Override
    public void makeFile(String path, String content) throws IOException {
        FileUtil.createFile(path, content);
    }

    @Override
    public void makeDirectory(String path) throws IOException {
        if (!new File(path).mkdirs()) {
            throw new IOException("make directory failed: " + path);
        }
    }

    @Override
    public boolean exists(String path) {
        return new File(path).exists();
    }

    @Override
    public String[] list(String path) {
        File file = new File(path);
        return file.isDirectory() ? file.list() : new String[]{};
    }

    @Override
    public String getContent(String path) throws Exception {
        return FileUtil.getFileContent(path);
    }
}

