/*
 * Decompiled with CFR 0.152.
 */
package fitnesse;

import fitnesse.FitNesseContext;
import fitnesse.FitNesseExpediter;
import fitnesse.FitNesseServer;
import fitnesse.FitNesseVersion;
import fitnesse.Updater;
import fitnesse.http.MockRequestBuilder;
import fitnesse.http.MockResponseSender;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.socketservice.SocketService;
import fitnesse.testutil.MockSocket;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.BindException;

public class FitNesse {
    private FitNesseContext context;
    private SocketService theService;
    private Updater updater;
    public static final FitNesseVersion VERSION = new FitNesseVersion();

    public static void main(String[] args) throws Exception {
        System.out.println("DEPRECATED:  use java -jar fitnesse.jar or java -cp fitnesse.jar fitnesseMain.FitNesseMain");
        Class<?> mainClass = Class.forName("fitnesseMain.FitNesseMain");
        Method mainMethod = mainClass.getMethod("main", String[].class);
        mainMethod.invoke(null, new Object[]{args});
    }

    private static void printBadPortMessage(int port) {
        System.err.println("FitNesse cannot be started...");
        System.err.println("Port " + port + " is already in use.");
        System.err.println("Use the -p <port#> command line argument to use a different port.");
    }

    private static void establishDirectory(String path) {
        File filesDir = new File(path);
        if (!filesDir.exists()) {
            filesDir.mkdir();
        }
    }

    public FitNesse(FitNesseContext context) {
        this(context, null, true);
    }

    public FitNesse(FitNesseContext context, Updater updater) {
        this(context, updater, true);
    }

    public FitNesse(FitNesseContext context, boolean makeDirs) {
        this(context, null, makeDirs);
    }

    public FitNesse(FitNesseContext context, Updater updater, boolean makeDirs) {
        this.updater = updater;
        this.context = context;
        context.fitnesse = this;
        FitNesseContext.globalContext = context;
        if (makeDirs) {
            this.establishRequiredDirectories();
        }
    }

    public boolean start() {
        try {
            if (this.context.port > 0) {
                this.theService = new SocketService(this.context.port, new FitNesseServer(this.context));
            }
            return true;
        }
        catch (BindException e) {
            FitNesse.printBadPortMessage(this.context.port);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void stop() throws Exception {
        if (this.theService != null) {
            this.theService.close();
            this.theService = null;
        }
    }

    private void establishRequiredDirectories() {
        FitNesse.establishDirectory(this.context.rootPagePath);
        FitNesse.establishDirectory(this.context.rootPagePath + "/files");
    }

    public void applyUpdates() throws Exception {
        if (this.updater != null) {
            this.updater.update();
        }
    }

    public boolean isRunning() {
        return this.theService != null;
    }

    public FitNesseContext getContext() {
        return this.context;
    }

    public void executeSingleCommand(String command, OutputStream out) throws Exception {
        Request request = new MockRequestBuilder(command).build();
        FitNesseExpediter expediter = new FitNesseExpediter(new MockSocket(), this.context);
        Response response = expediter.createGoodResponse(request);
        MockResponseSender.OutputStreamSender sender = new MockResponseSender.OutputStreamSender(out);
        ((MockResponseSender)sender).doSending(response);
    }
}

