/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.authentication;

import fitnesse.FitNesseContext;
import fitnesse.Responder;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.authentication.UnauthorizedResponder;
import fitnesse.http.Request;

public abstract class Authenticator {
    public Responder authenticate(FitNesseContext context, Request request, Responder privilegedResponder) throws Exception {
        request.getCredentials();
        String username = request.getAuthorizationUsername();
        String password = request.getAuthorizationPassword();
        if (this.isAuthenticated(username, password)) {
            return privilegedResponder;
        }
        if (!this.isSecureResponder(privilegedResponder)) {
            return privilegedResponder;
        }
        return this.verifyOperationIsSecure(privilegedResponder, context, request);
    }

    private Responder verifyOperationIsSecure(Responder privilegedResponder, FitNesseContext context, Request request) {
        SecureOperation so = ((SecureResponder)privilegedResponder).getSecureOperation();
        try {
            if (so.shouldAuthenticate(context, request)) {
                return this.unauthorizedResponder(context, request);
            }
            return privilegedResponder;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.unauthorizedResponder(context, request);
        }
    }

    protected Responder unauthorizedResponder(FitNesseContext context, Request request) {
        return new UnauthorizedResponder();
    }

    private boolean isSecureResponder(Responder privilegedResponder) {
        return privilegedResponder instanceof SecureResponder;
    }

    public abstract boolean isAuthenticated(String var1, String var2) throws Exception;

    public String toString() {
        return this.getClass().getName();
    }
}

