/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.html;

import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageCrawlerImpl;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SetupTeardownAndLibraryIncluder {
    private PageData pageData;
    private boolean isSuite;
    private WikiPage testPage;
    private StringBuffer newPageContent;
    private PageCrawler pageCrawler;

    public static void includeInto(PageData pageData) throws Exception {
        SetupTeardownAndLibraryIncluder.includeInto(pageData, false);
    }

    public static void includeInto(PageData pageData, boolean isSuite) throws Exception {
        new SetupTeardownAndLibraryIncluder(pageData).includeInto(isSuite);
    }

    public static void includeSetupsTeardownsAndLibrariesBelowTheSuite(PageData pageData, WikiPage suitePage) throws Exception {
        new SetupTeardownAndLibraryIncluder(pageData).includeSetupsTeardownsAndLibrariesBelowTheSuite(suitePage);
    }

    private SetupTeardownAndLibraryIncluder(PageData pageData) {
        this.pageData = pageData;
        this.testPage = pageData.getWikiPage();
        this.pageCrawler = this.testPage.getPageCrawler();
        this.newPageContent = new StringBuffer();
    }

    private void includeInto(boolean isSuite) throws Exception {
        this.isSuite = isSuite;
        if (this.isTestPage()) {
            this.includeSetupTeardownAndLibraryPages();
        }
    }

    private boolean isTestPage() throws Exception {
        return this.pageData.hasAttribute("Test");
    }

    private void includeSetupTeardownAndLibraryPages() throws Exception {
        this.includeScenarioLibraries();
        this.includeSetupPages();
        this.includePageContent();
        this.includeTeardownPages();
        this.updatePageContent();
    }

    private void includeSetupsTeardownsAndLibrariesBelowTheSuite(WikiPage suitePage) throws Exception {
        String pageName = this.testPage.getName();
        this.includeScenarioLibraryBelow(suitePage);
        if (!this.isSuiteSetUpOrTearDownPage(pageName)) {
            this.includeSetupPages();
        }
        this.includePageContent();
        if (!this.isSuiteSetUpOrTearDownPage(pageName)) {
            this.includeTeardownPages();
        }
        this.updatePageContent();
    }

    private boolean isSuiteSetUpOrTearDownPage(String pageName) {
        return "SuiteSetUp".equals(pageName) || "SuiteTearDown".equals(pageName);
    }

    private void includeScenarioLibraryBelow(WikiPage suitePage) throws Exception {
        this.includeScenarioLibrariesIfAppropriate(new BelowSuiteLibraryFilter(suitePage));
    }

    private void includeScenarioLibraries() throws Exception {
        this.includeScenarioLibrariesIfAppropriate(AllLibrariesFilter.instance);
    }

    private void includeSetupPages() throws Exception {
        if (this.isSuite) {
            this.includeSuiteSetupPage();
        }
        this.includeSetupPage();
    }

    private void includeSuiteSetupPage() throws Exception {
        this.include("SuiteSetUp", "-setup");
    }

    private void includeSetupPage() throws Exception {
        this.include("SetUp", "-setup");
    }

    private void includePageContent() throws Exception {
        this.newPageContent.append(this.pageData.getContent());
    }

    private void includeTeardownPages() throws Exception {
        this.includeTeardownPage();
        if (this.isSuite) {
            this.includeSuiteTeardownPage();
        }
    }

    private void includeTeardownPage() throws Exception {
        this.include("TearDown", "-teardown");
    }

    private void includeSuiteTeardownPage() throws Exception {
        this.include("SuiteTearDown", "-teardown");
    }

    private void updatePageContent() throws Exception {
        this.pageData.setContent(this.newPageContent.toString());
    }

    private void include(String pageName, String arg) throws Exception {
        WikiPage inheritedPage = this.findInheritedPage(pageName);
        if (inheritedPage != null) {
            String pagePathName = this.getPathNameForPage(inheritedPage);
            this.includePage(pagePathName, arg);
        }
    }

    private void includeScenarioLibrariesIfAppropriate(LibraryFilter libraryFilter) throws Exception {
        if (this.isSlim(this.testPage)) {
            this.includeScenarioLibrariesIfAny(libraryFilter);
        }
    }

    private void includeScenarioLibrariesIfAny(LibraryFilter libraryFilter) throws Exception {
        List<WikiPage> uncles = PageCrawlerImpl.getAllUncles("ScenarioLibrary", this.testPage);
        List<WikiPage> filteredUncles = this.filter(uncles, libraryFilter);
        if (filteredUncles.size() > 0) {
            this.includeScenarioLibraries(filteredUncles);
        }
    }

    private List<WikiPage> filter(List<WikiPage> widgets, LibraryFilter filter) throws Exception {
        LinkedList<WikiPage> filteredList = new LinkedList<WikiPage>();
        for (WikiPage widget : widgets) {
            if (!filter.canUse(widget)) continue;
            filteredList.add(widget);
        }
        return filteredList;
    }

    private boolean isSlim(WikiPage page) throws Exception {
        String testSystem = page.getData().getVariable("TEST_SYSTEM");
        boolean isSlim = "slim".equalsIgnoreCase(testSystem);
        return isSlim;
    }

    private void includeScenarioLibraries(List<WikiPage> uncles) throws Exception {
        Collections.reverse(uncles);
        this.newPageContent.append("!*> Scenario Libraries\n");
        for (WikiPage uncle : uncles) {
            this.includeScenarioLibrary(uncle);
        }
        this.newPageContent.append("*!\n");
    }

    private void includeScenarioLibrary(WikiPage uncle) throws Exception {
        this.newPageContent.append("!include -c .");
        this.newPageContent.append(PathParser.render(this.pageCrawler.getFullPath(uncle)));
        this.newPageContent.append("\n");
    }

    private WikiPage findInheritedPage(String pageName) throws Exception {
        return PageCrawlerImpl.getClosestInheritedPage(pageName, this.testPage);
    }

    private String getPathNameForPage(WikiPage page) throws Exception {
        WikiPagePath pagePath = this.pageCrawler.getFullPath(page);
        return PathParser.render(pagePath);
    }

    private void includePage(String pagePathName, String arg) {
        this.newPageContent.append("\n!include ").append(arg).append(" .").append(pagePathName).append("\n");
    }

    private class BelowSuiteLibraryFilter
    implements LibraryFilter {
        private int minimumPathLength;

        public BelowSuiteLibraryFilter(WikiPage suitePage) throws Exception {
            this.minimumPathLength = suitePage.getPageCrawler().getFullPath(suitePage).addNameToEnd("ScenarioLibrary").toString().length();
        }

        @Override
        public boolean canUse(WikiPage libraryPage) throws Exception {
            return libraryPage.getPageCrawler().getFullPath(libraryPage).toString().length() > this.minimumPathLength;
        }
    }

    private static class AllLibrariesFilter
    implements LibraryFilter {
        public static AllLibrariesFilter instance = new AllLibrariesFilter();

        private AllLibrariesFilter() {
        }

        @Override
        public boolean canUse(WikiPage libraryPage) {
            return true;
        }
    }

    private static interface LibraryFilter {
        public boolean canUse(WikiPage var1) throws Exception;
    }
}

