/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.components.CommandRunner;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.run.ExecutionStatus;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.VirtualEnabledPageCrawler;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import util.Clock;

public class ExecutionLog {
    public static final String ErrorLogName = "ErrorLogs";
    private PageCrawler crawler;
    private String errorLogPageName;
    private WikiPagePath errorLogPagePath;
    private WikiPage root;
    private WikiPage testPage;
    private CommandRunner runner;
    private List<String> reasons = new LinkedList<String>();
    private List<Throwable> exceptions = new LinkedList<Throwable>();

    private static SimpleDateFormat makeDateFormat() {
        return new SimpleDateFormat("h:mm:ss a (z) 'on' EEEE, MMMM d, yyyy");
    }

    public ExecutionLog(WikiPage testPage, CommandRunner client) throws Exception {
        this.testPage = testPage;
        this.runner = client;
        this.crawler = testPage.getPageCrawler();
        this.crawler.setDeadEndStrategy(new VirtualEnabledPageCrawler());
        this.root = this.crawler.getRoot(testPage);
        this.errorLogPagePath = this.crawler.getFullPath(testPage).addNameToFront(ErrorLogName);
        this.errorLogPageName = PathParser.render(this.errorLogPagePath);
    }

    void addException(Throwable e) {
        this.exceptions.add(e);
    }

    void addReason(String reason) {
        if (!this.reasons.contains(reason)) {
            this.reasons.add(reason);
        }
    }

    public void publish() throws Exception {
        String content = this.buildLogContent();
        WikiPage errorLogPage = this.crawler.addPage(this.root, this.errorLogPagePath);
        PageData data = errorLogPage.getData();
        data.setContent(content);
        errorLogPage.commit(data);
    }

    String buildLogContent() throws Exception {
        StringBuffer buffer = new StringBuffer();
        this.addLiteralEntry(buffer, "Date", ExecutionLog.makeDateFormat().format(Clock.currentDate()));
        this.addEntry(buffer, "Test Page", "." + PathParser.render(this.crawler.getFullPath(this.testPage)));
        this.addLiteralEntry(buffer, "Command", this.runner.getCommand());
        this.addLiteralEntry(buffer, "Exit code", String.valueOf(this.runner.getExitCode()));
        this.addLiteralEntry(buffer, "Time elapsed", (double)this.runner.getExecutionTime() / 1000.0 + " seconds");
        if (this.runner.wroteToOutputStream()) {
            this.addOutputBlock(buffer);
        }
        if (this.runner.wroteToErrorStream()) {
            this.addErrorBlock(buffer);
        }
        if (this.runner.hasExceptions() || this.exceptions.size() > 0) {
            this.addExceptionBlock(buffer);
        }
        return buffer.toString();
    }

    private void addLiteralEntry(StringBuffer buffer, String key, String value) {
        this.addEntry(buffer, key, this.literalize(value));
    }

    private void addEntry(StringBuffer buffer, String key, String value) {
        buffer.append("|'''").append(key).append(": '''|").append(value).append("|\n");
    }

    private String literalize(String s) {
        return String.format("!-%s-!", s);
    }

    private void addOutputBlock(StringBuffer buffer) {
        buffer.append("----");
        buffer.append("'''Standard Output:'''").append("\n");
        buffer.append("{{{").append(this.runner.getOutput()).append("}}}");
    }

    private void addErrorBlock(StringBuffer buffer) {
        buffer.append("----");
        buffer.append("'''Standard Error:'''").append("\n");
        buffer.append("{{{").append(this.runner.getError()).append("}}}");
    }

    private void addExceptionBlock(StringBuffer buffer) {
        this.exceptions.addAll(this.runner.getExceptions());
        buffer.append("----");
        buffer.append("'''Internal Exception");
        if (this.exceptions.size() > 1) {
            buffer.append("s");
        }
        buffer.append(":'''").append("\n");
        for (Throwable exception : this.exceptions) {
            buffer.append("{{{ ").append(ErrorResponder.makeExceptionString(exception)).append("}}}");
        }
    }

    int exceptionCount() {
        return this.exceptions.size();
    }

    String getErrorLogPageName() {
        return this.errorLogPageName;
    }

    boolean hasCapturedOutput() {
        return this.runner.wroteToErrorStream() || this.runner.wroteToOutputStream();
    }

    public String executionStatusHtml() throws Exception {
        String linkHref = this.getErrorLogPageName();
        return this.executionStatusHtml(linkHref);
    }

    private String executionStatusHtml(String linkHref) throws Exception {
        ExecutionStatus executionStatus = this.exceptionCount() > 0 ? ExecutionStatus.ERROR : (this.hasCapturedOutput() ? ExecutionStatus.OUTPUT : ExecutionStatus.OK);
        return ExecutionLog.makeExecutionStatusLink(linkHref, executionStatus);
    }

    public static String makeExecutionStatusLink(String linkHref, ExecutionStatus executionStatus) throws Exception {
        HtmlTag status = new HtmlTag("div");
        status.addAttribute("id", "execution-status");
        HtmlTag image = new HtmlTag("img");
        image.addAttribute("src", "/files/images/executionStatus/" + executionStatus.getIconFilename());
        status.add(HtmlUtil.makeLink(linkHref, image.html()));
        status.add(HtmlUtil.BR);
        status.add(HtmlUtil.makeLink(linkHref, executionStatus.getMessage()));
        return status.html();
    }

    public int getExitCode() {
        return this.runner.getExitCode();
    }

    public CommandRunner getCommandRunner() {
        return this.runner;
    }
}

