/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.MultipleTestsRunner;
import fitnesse.responders.run.SuiteContentsFinder;
import fitnesse.responders.run.SuiteFilter;
import fitnesse.responders.run.TestResponder;
import fitnesse.responders.run.formatters.CachingSuiteXmlFormatter;
import fitnesse.responders.run.formatters.PageHistoryFormatter;
import fitnesse.responders.run.formatters.SuiteHistoryFormatter;
import fitnesse.responders.run.formatters.SuiteHtmlFormatter;

public class SuiteResponder
extends TestResponder {
    private boolean includeHtml;

    @Override
    String getTitle() {
        return "Suite Results";
    }

    @Override
    protected void checkArguments() {
        super.checkArguments();
        this.includeHtml |= this.request.hasInput("includehtml");
    }

    @Override
    void addXmlFormatter() throws Exception {
        CachingSuiteXmlFormatter xmlFormatter = new CachingSuiteXmlFormatter(this.context, this.page, this.makeResponseWriter());
        if (this.includeHtml) {
            xmlFormatter.includeHtml();
        }
        this.formatters.add(xmlFormatter);
    }

    @Override
    void addHtmlFormatter() throws Exception {
        SuiteHtmlFormatter formatter = new SuiteHtmlFormatter(this.context, this.page, this.context.htmlPageFactory){

            @Override
            protected void writeData(String output) throws Exception {
                SuiteResponder.this.addToResponse(output);
            }
        };
        this.formatters.add(formatter);
    }

    @Override
    protected void addTestHistoryFormatter() throws Exception {
        TestResponder.HistoryWriterFactory source = new TestResponder.HistoryWriterFactory();
        this.formatters.add(new PageHistoryFormatter(this.context, this.page, source));
        this.formatters.add(new SuiteHistoryFormatter(this.context, this.page, source));
    }

    @Override
    protected void performExecution() throws Exception {
        SuiteFilter filter = new SuiteFilter(this.request, this.page.getPageCrawler().getFullPath(this.page).toString());
        SuiteContentsFinder suiteTestFinder = new SuiteContentsFinder(this.page, filter, this.root);
        MultipleTestsRunner runner = new MultipleTestsRunner(suiteTestFinder.getAllPagesToRunForThisSuite(), this.context, this.page, this.formatters);
        runner.setDebug(this.isRemoteDebug());
        runner.setFastTest(this.isFastTest());
        runner.executeTestPages();
    }
}

