/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run;

import fitnesse.responders.run.ExecutionLog;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystemListener;
import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;
import java.util.Collections;
import java.util.Map;

public abstract class TestSystem
implements TestSystemListener {
    public static final String DEFAULT_COMMAND_PATTERN = "java -cp fitnesse.jar" + System.getProperties().get("path.separator") + "%p %m";
    public static final String DEFAULT_JAVA_DEBUG_COMMAND = "java -Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=8000 -cp %p %m";
    public static final String DEFAULT_CSHARP_DEBUG_RUNNER_FIND = "runner.exe";
    public static final String DEFAULT_CSHARP_DEBUG_RUNNER_REPLACE = "runnerw.exe";
    protected WikiPage page;
    protected boolean fastTest;
    protected boolean manualStart;
    protected static final String emptyPageContent = "OH NO! This page is empty!";
    protected TestSystemListener testSystemListener;
    protected ExecutionLog log;

    public TestSystem(WikiPage page, TestSystemListener testSystemListener) {
        this.page = page;
        this.testSystemListener = testSystemListener;
    }

    public ExecutionLog getExecutionLog(String classPath, Descriptor descriptor) throws Exception {
        this.log = this.createExecutionLog(classPath, descriptor);
        return this.log;
    }

    protected abstract ExecutionLog createExecutionLog(String var1, Descriptor var2) throws Exception;

    protected String buildCommand(Descriptor descriptor, String classPath) throws Exception {
        String commandPattern = descriptor.commandPattern;
        String command = TestSystem.replace(commandPattern, "%p", classPath);
        command = TestSystem.replace(command, "%m", descriptor.testRunner);
        return command;
    }

    private static String getRemoteDebugCommandPattern(PageData pageData) throws Exception {
        String testRunner = pageData.getVariable("REMOTE_DEBUG_COMMAND");
        if (testRunner == null && ((testRunner = pageData.getVariable("COMMAND_PATTERN")) == null || testRunner.toLowerCase().contains("java"))) {
            testRunner = DEFAULT_JAVA_DEBUG_COMMAND;
        }
        return testRunner;
    }

    private static String getNormalCommandPattern(PageData pageData) throws Exception {
        String testRunner = pageData.getVariable("COMMAND_PATTERN");
        if (testRunner == null) {
            testRunner = DEFAULT_COMMAND_PATTERN;
        }
        return testRunner;
    }

    private static String getCommandPattern(PageData pageData, boolean isRemoteDebug) throws Exception {
        if (isRemoteDebug) {
            return TestSystem.getRemoteDebugCommandPattern(pageData);
        }
        return TestSystem.getNormalCommandPattern(pageData);
    }

    protected static String replace(String value, String mark, String replacement) {
        int index = value.indexOf(mark);
        if (index == -1) {
            return value;
        }
        return value.substring(0, index) + replacement + value.substring(index + mark.length());
    }

    public void setFastTest(boolean fastTest) {
        this.fastTest = fastTest;
    }

    public void setManualStart(boolean manualStart) {
        this.manualStart = manualStart;
    }

    public static String getTestSystemName(PageData data) throws Exception {
        String testSystemName = TestSystem.getTestSystem(data);
        String testRunner = TestSystem.getTestRunnerNormal(data);
        return String.format("%s:%s", testSystemName, testRunner);
    }

    private static String getTestSystem(PageData data) throws Exception {
        String testSystemName = data.getVariable("TEST_SYSTEM");
        if (testSystemName == null) {
            return "fit";
        }
        return testSystemName;
    }

    public static String getPathSeparator(PageData pageData) throws Exception {
        String separator = pageData.getVariable("PATH_SEPARATOR");
        if (separator == null) {
            separator = (String)System.getProperties().get("path.separator");
        }
        return separator;
    }

    public static String getTestSystemType(String testSystemName) throws Exception {
        String[] parts = testSystemName.split(":");
        return parts[0];
    }

    @Override
    public void acceptOutputFirst(String output) throws Exception {
        this.testSystemListener.acceptOutputFirst(output);
    }

    @Override
    public void testComplete(TestSummary testSummary) throws Exception {
        this.testSystemListener.testComplete(testSummary);
    }

    @Override
    public void exceptionOccurred(Throwable e) {
        this.log.addException(e);
        this.log.addReason("Test execution aborted abnormally with error code " + this.log.getExitCode());
        this.testSystemListener.exceptionOccurred(e);
    }

    public abstract void start() throws Exception;

    private static String getTestRunner(PageData pageData, boolean isRemoteDebug) throws Exception {
        if (isRemoteDebug) {
            return TestSystem.getTestRunnerDebug(pageData);
        }
        return TestSystem.getTestRunnerNormal(pageData);
    }

    private static String getTestRunnerDebug(PageData data) throws Exception {
        String program = data.getVariable("REMOTE_DEBUG_RUNNER");
        if (program == null && (program = TestSystem.getTestRunnerNormal(data)).toLowerCase().contains(DEFAULT_CSHARP_DEBUG_RUNNER_FIND)) {
            program = program.toLowerCase().replace(DEFAULT_CSHARP_DEBUG_RUNNER_FIND, DEFAULT_CSHARP_DEBUG_RUNNER_REPLACE);
        }
        return program;
    }

    public static String getTestRunnerNormal(PageData data) throws Exception {
        String program = data.getVariable("TEST_RUNNER");
        if (program == null) {
            program = TestSystem.defaultTestRunner(data);
        }
        return program;
    }

    static String defaultTestRunner(PageData data) throws Exception {
        String testSystemType = TestSystem.getTestSystemType(TestSystem.getTestSystem(data));
        if ("slim".equalsIgnoreCase(testSystemType)) {
            return "fitnesse.slim.SlimService";
        }
        return "fit.FitServer";
    }

    public abstract void bye() throws Exception;

    public abstract boolean isSuccessfullyStarted();

    public abstract void kill() throws Exception;

    public abstract String runTestsAndGenerateHtml(PageData var1) throws Exception;

    public static Descriptor getDescriptor(PageData data, boolean isRemoteDebug) throws Exception {
        String testSystemName = TestSystem.getTestSystem(data);
        String testRunner = TestSystem.getTestRunner(data, isRemoteDebug);
        String commandPattern = TestSystem.getCommandPattern(data, isRemoteDebug);
        String pathSeparator = TestSystem.getPathSeparator(data);
        return new Descriptor(testSystemName, testRunner, commandPattern, pathSeparator);
    }

    protected Map<String, String> createClasspathEnvironment(String classPath) throws Exception {
        String classpathProperty = this.page.getData().getVariable("CLASSPATH_PROPERTY");
        Map<String, String> environmentVariables = null;
        if (classpathProperty != null) {
            environmentVariables = Collections.singletonMap(classpathProperty, classPath);
        }
        return environmentVariables;
    }

    public static class Descriptor {
        public String testSystemName;
        public String testRunner;
        public String commandPattern;
        public String pathSeparator;

        public Descriptor(String testSystemName, String testRunner, String commandPattern, String pathSeparator) {
            this.testSystemName = testSystemName;
            this.testRunner = testRunner;
            this.commandPattern = commandPattern;
            this.pathSeparator = pathSeparator;
        }

        public int hashCode() {
            return this.testSystemName.hashCode() ^ this.testRunner.hashCode() ^ this.commandPattern.hashCode() ^ this.pathSeparator.hashCode();
        }

        public boolean equals(Object obj) {
            Descriptor d = (Descriptor)obj;
            return d.testSystemName.equals(this.testSystemName) && d.testRunner.equals(this.testRunner) && d.commandPattern.equals(this.commandPattern) && d.pathSeparator.equals(this.pathSeparator);
        }
    }
}

