/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.run.slimResponder;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureTestOperation;
import fitnesse.components.ClassPathBuilder;
import fitnesse.responders.WikiPageResponder;
import fitnesse.responders.run.ExecutionLog;
import fitnesse.responders.run.TestSummary;
import fitnesse.responders.run.TestSystem;
import fitnesse.responders.run.TestSystemListener;
import fitnesse.responders.run.slimResponder.SlimTestSystem;
import fitnesse.wiki.PageData;

public abstract class SlimResponder
extends WikiPageResponder
implements TestSystemListener {
    private boolean slimOpen = false;
    ExecutionLog log;
    private boolean fastTest = false;
    SlimTestSystem testSystem;

    @Override
    protected String generateHtml(PageData pageData) throws Exception {
        this.testSystem = this.getTestSystem(pageData);
        String classPath = new ClassPathBuilder().getClasspath(this.page);
        TestSystem.Descriptor descriptor = TestSystem.getDescriptor(this.page.getData(), false);
        descriptor.testRunner = "fitnesse.slim.SlimService";
        this.log = this.testSystem.getExecutionLog(classPath, descriptor);
        this.testSystem.start();
        this.testSystem.setFastTest(this.fastTest);
        String html = this.testSystem.runTestsAndGenerateHtml(pageData);
        this.testSystem.bye();
        Thread.sleep(20L);
        return html;
    }

    protected abstract SlimTestSystem getTestSystem(PageData var1);

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureTestOperation();
    }

    boolean slimOpen() {
        return this.slimOpen;
    }

    public PageData getTestResults() {
        return this.testSystem.getTestResults();
    }

    public TestSummary getTestSummary() {
        return this.testSystem.getTestSummary();
    }

    protected void setFastTest(boolean fastTest) {
        this.fastTest = fastTest;
    }

    @Override
    public void acceptOutputFirst(String output) throws Exception {
    }

    @Override
    public void testComplete(TestSummary testSummary) throws Exception {
    }

    @Override
    public void exceptionOccurred(Throwable e) {
        System.err.println("SlimResponder.exceptionOcurred:" + e.getMessage());
    }

    public String getCommandLine() {
        return this.testSystem.getCommandLine();
    }
}

