/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.testHistory;

import fitnesse.responders.testHistory.PageHistoryReader;
import fitnesse.responders.testHistory.TestResultRecord;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class PageHistory
extends PageHistoryReader {
    private int failures = 0;
    private int passes = 0;
    private Date minDate = null;
    private Date maxDate = null;
    private int maxAssertions = 0;
    private BarGraph barGraph;
    private String fullPageName;
    private final HashMap<Date, TestResultRecord> testResultMap = new HashMap();
    private HashMap<Date, File> pageFiles = new HashMap();

    public PageHistory(File pageDirectory) {
        this.fullPageName = pageDirectory.getName();
        try {
            this.readHistoryFromPageDirectory(pageDirectory);
            this.compileBarGraph();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void compileBarGraph() {
        ArrayList<Date> dates = new ArrayList<Date>(this.testResultMap.keySet());
        Collections.sort(dates, this.reverseChronologicalDateComparator());
        this.barGraph = new BarGraph();
        for (int i = 0; i < dates.size() && i < 20; ++i) {
            Date date = (Date)dates.get(i);
            this.barGraph.addSummary(date, this.get(date));
        }
    }

    private Comparator<Date> reverseChronologicalDateComparator() {
        return new Comparator<Date>(){

            @Override
            public int compare(Date d1, Date d2) {
                long diff = d2.getTime() - d1.getTime();
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                return 0;
            }
        };
    }

    @Override
    void processTestFile(TestResultRecord record) throws ParseException {
        Date date = record.getDate();
        this.addTestResult(record, date);
        this.countResult(record);
        this.setMinMaxDate(date);
        this.setMaxAssertions(record);
        this.pageFiles.put(date, record.getFile());
    }

    private void addTestResult(TestResultRecord record, Date date) {
        Date keyDate = this.trimMilliseconds(date);
        this.testResultMap.put(date, record);
    }

    private Date trimMilliseconds(Date date) {
        long milliseconds = date.getTime();
        long seconds = milliseconds / 1000L;
        return new Date(seconds * 1000L);
    }

    public String getPageFileName(Date date) {
        if (this.pageFiles.get(date) != null) {
            return this.pageFiles.get(date).getName();
        }
        return null;
    }

    private void setMaxAssertions(TestResultRecord summary) {
        int assertions = summary.getRight() + summary.getWrong() + summary.getExceptions();
        this.maxAssertions = Math.max(this.maxAssertions, assertions);
    }

    private void setMinMaxDate(Date date) {
        if (this.minDate == null) {
            this.minDate = this.maxDate = date;
        } else if (date.getTime() > this.maxDate.getTime()) {
            this.maxDate = date;
        } else if (date.getTime() < this.minDate.getTime()) {
            this.minDate = date;
        }
    }

    private void countResult(TestResultRecord summary) {
        if (summary.getWrong() > 0 || summary.getExceptions() > 0 || summary.getRight() == 0) {
            ++this.failures;
        } else {
            ++this.passes;
        }
    }

    public int getFailures() {
        return this.failures;
    }

    public int getPasses() {
        return this.passes;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    public BarGraph getBarGraph() {
        return this.barGraph;
    }

    public int size() {
        return this.testResultMap.size();
    }

    public TestResultRecord get(Date key) {
        return this.testResultMap.get(this.trimMilliseconds(key));
    }

    public int maxAssertions() {
        return this.maxAssertions;
    }

    public SortedSet<Date> datesInChronologicalOrder() {
        Set<Date> dates = this.testResultMap.keySet();
        TreeSet<Date> sortedDates = new TreeSet<Date>(Collections.reverseOrder());
        sortedDates.addAll(dates);
        return sortedDates;
    }

    public PassFailBar getPassFailBar(Date date, int maxUnits) {
        TestResultRecord summary = this.get(date);
        int fail = summary.getWrong() + summary.getExceptions();
        double unitsPerAssertion = (double)maxUnits / (double)this.maxAssertions;
        int unitsForThisTest = (int)Math.round((double)(fail + summary.getRight()) * unitsPerAssertion);
        double doubleFailUnits = (double)fail * unitsPerAssertion;
        int failUnits = (int)doubleFailUnits;
        if (Math.abs(doubleFailUnits - (double)failUnits) > 0.001) {
            ++failUnits;
        }
        int passUnits = unitsForThisTest - failUnits;
        return new PassFailBar(summary.getRight(), fail, passUnits, failUnits);
    }

    public String getFullPageName() {
        return this.fullPageName;
    }

    public Date getLatestDate() {
        Set<Date> dateSet = this.testResultMap.keySet();
        ArrayList<Date> dates = new ArrayList<Date>(dateSet);
        Collections.sort(dates);
        return (Date)dates.get(dates.size() - 1);
    }

    public static String formatDate(String format, Date date) {
        SimpleDateFormat fmt = new SimpleDateFormat(format, Locale.US);
        return fmt.format(date);
    }

    public class PassFailBar {
        private int passUnits;
        private int failUnits;
        private int pass;
        private int fail;

        public PassFailBar(int pass, int fail, int passUnits, int failUnits) {
            this.pass = pass;
            this.fail = fail;
            this.passUnits = passUnits;
            this.failUnits = failUnits;
        }

        public int getPassUnits() {
            return this.passUnits;
        }

        public int getFailUnits() {
            return this.failUnits;
        }

        public int getPass() {
            return this.pass;
        }

        public int getFail() {
            return this.fail;
        }
    }

    public static class BarGraph {
        private Date startingDate;
        private Date endingDate;
        private List<PassFailReport> passFailList = new ArrayList<PassFailReport>();

        public Date getStartingDate() {
            return this.startingDate;
        }

        public String formatStartingDate(String format) {
            return PageHistory.formatDate(format, this.startingDate);
        }

        public String formatEndingDate(String format) {
            return PageHistory.formatDate(format, this.endingDate);
        }

        public Date getEndingDate() {
            return this.endingDate;
        }

        public void addSummary(Date date, TestResultRecord summary) {
            this.minMaxDate(summary);
            boolean pass = summary.getWrong() == 0 && summary.getExceptions() == 0 && summary.getRight() > 0;
            this.passFailList.add(new PassFailReport(date, pass));
        }

        private void minMaxDate(TestResultRecord summary) {
            Date date = summary.getDate();
            if (this.startingDate == null) {
                this.startingDate = this.endingDate = date;
            } else if (date.getTime() < this.startingDate.getTime()) {
                this.startingDate = date;
            } else if (date.getTime() > this.endingDate.getTime()) {
                this.endingDate = date;
            }
        }

        public int size() {
            return this.passFailList.size();
        }

        public PassFailReport getPassFail(int i) {
            return this.passFailList.get(i);
        }

        public PassFailReport[] passFailArray() {
            return this.passFailList.toArray(new PassFailReport[this.passFailList.size()]);
        }

        public String testString() {
            StringBuilder builder = new StringBuilder();
            for (PassFailReport report : this.passFailList) {
                builder.append(report.pass ? "+" : "-");
            }
            return builder.toString();
        }
    }

    public static class PassFailReport {
        private String date;
        private boolean pass;

        public PassFailReport(Date date, boolean pass) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            this.date = dateFormat.format(date);
            this.pass = pass;
        }

        public String getDate() {
            return this.date;
        }

        public boolean isPass() {
            return this.pass;
        }
    }
}

