/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.versions;

import fitnesse.FitNesseContext;
import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.authentication.SecureResponder;
import fitnesse.html.HtmlPage;
import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.http.Request;
import fitnesse.http.Response;
import fitnesse.http.SimpleResponse;
import fitnesse.responders.ErrorResponder;
import fitnesse.responders.NotFoundResponder;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PathParser;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageAction;
import fitnesse.wiki.WikiPagePath;

public class VersionResponder
implements SecureResponder {
    private String version;
    private String resource;

    @Override
    public Response makeResponse(FitNesseContext context, Request request) throws Exception {
        WikiPagePath path;
        this.resource = request.getResource();
        this.version = (String)request.getInput("version");
        if (this.version == null) {
            return new ErrorResponder("No version specified.").makeResponse(context, request);
        }
        PageCrawler pageCrawler = context.root.getPageCrawler();
        WikiPage page = pageCrawler.getPage(context.root, path = PathParser.parse(this.resource));
        if (page == null) {
            return new NotFoundResponder().makeResponse(context, request);
        }
        PageData pageData = page.getDataVersion(this.version);
        String fullPathName = PathParser.render(pageCrawler.getFullPath(page));
        HtmlPage html = this.makeHtml(fullPathName, pageData, context);
        SimpleResponse response = new SimpleResponse();
        response.setContent(html.html());
        return response;
    }

    private HtmlPage makeHtml(String name, PageData pageData, FitNesseContext context) throws Exception {
        HtmlPage html = context.htmlPageFactory.newPage();
        html.title.use("Version " + this.version + ": " + name);
        html.header.use(HtmlUtil.makeBreadCrumbsWithPageType(this.resource, "Version " + this.version));
        html.actions.use(this.makeRollbackLink(name));
        html.main.use(HtmlUtil.makeNormalWikiPageContent(pageData));
        return html;
    }

    private HtmlTag makeRollbackLink(String name) {
        WikiPageAction action = new WikiPageAction(name, "Rollback");
        action.setQuery("responder=rollback&version=" + this.version);
        action.setShortcutKey("");
        return HtmlUtil.makeAction(action);
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

