/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.ListDeserializer;
import fitnesse.slim.ListSerializer;
import fitnesse.slim.SlimError;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.ListUtility;
import util.StreamReader;

public class SlimClient {
    public static double MINIMUM_REQUIRED_SLIM_VERSION = 0.3;
    private Socket client;
    private StreamReader reader;
    private BufferedWriter writer;
    private String slimServerVersionMessage;
    private double slimServerVersion;
    private String hostName;
    private int port;

    public void close() throws Exception {
        this.reader.close();
        this.writer.close();
        this.client.close();
    }

    public SlimClient(String hostName, int port) {
        this.port = port;
        this.hostName = hostName;
    }

    public void connect() throws Exception {
        int tries = 0;
        while (!this.tryConnect()) {
            if (tries > 100) {
                throw new SlimError("Could not start Slim.");
            }
            Thread.sleep(50L);
            ++tries;
        }
        this.reader = new StreamReader(this.client.getInputStream());
        this.writer = new BufferedWriter(new OutputStreamWriter(this.client.getOutputStream(), "UTF-8"));
        this.slimServerVersionMessage = this.reader.readLine();
        this.slimServerVersion = this.isConnected() ? Double.parseDouble(this.slimServerVersionMessage.replace("Slim -- V", "")) : -1.0;
    }

    private boolean tryConnect() {
        try {
            this.client = new Socket(this.hostName, this.port);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public double getServerVersion() {
        return this.slimServerVersion;
    }

    public boolean isConnected() {
        return this.slimServerVersionMessage.startsWith("Slim -- V");
    }

    public Map<String, Object> invokeAndGetResponse(List<Object> statements) throws Exception {
        if (statements.size() == 0) {
            return new HashMap<String, Object>();
        }
        String instructions = ListSerializer.serialize(statements);
        this.writeString(instructions);
        String resultLength = this.reader.read(6);
        this.reader.read(1);
        String results = null;
        results = this.reader.read(Integer.parseInt(resultLength));
        List<Object> resultList = ListDeserializer.deserialize(results);
        return SlimClient.resultToMap(resultList);
    }

    private void writeString(String string) throws IOException {
        String packet = String.format("%06d:%s", string.getBytes("UTF-8").length, string);
        this.writer.write(packet);
        this.writer.flush();
    }

    public void sendBye() throws IOException {
        this.writeString("bye");
    }

    public static Map<String, Object> resultToMap(List<Object> slimResults) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object aResult : slimResults) {
            List resultList = ListUtility.uncheckedCast(Object.class, aResult);
            map.put((String)resultList.get(0), resultList.get(1));
        }
        return map;
    }
}

