/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import fitnesse.updates.Update;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.regex.Pattern;

public class FileUpdate
implements Update {
    protected String destination;
    protected String source;
    protected File destinationDir;
    protected String rootDir;
    protected String filename;

    public FileUpdate(String rootDirectory, String source, String destination) throws Exception {
        this.destination = destination;
        this.source = source;
        this.rootDir = rootDirectory;
        this.destinationDir = new File(new File(this.rootDir), destination);
        this.filename = new File(source).getName();
    }

    @Override
    public void doUpdate() throws Exception {
        this.makeSureDirectoriesExist();
        this.copyResource();
    }

    private void makeSureDirectoriesExist() {
        String[] subDirectories = this.destination.split(Pattern.quote(File.separator));
        String currentDirPath = this.rootDir;
        for (int i = 0; i < subDirectories.length; ++i) {
            String subDirectory = subDirectories[i];
            currentDirPath = currentDirPath + File.separator + subDirectory;
            File directory = new File(currentDirPath);
            directory.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource() throws Exception {
        URL url = this.getResource(this.source);
        if (url != null) {
            InputStream input = null;
            OutputStream output = null;
            try {
                int b;
                input = url.openStream();
                output = new FileOutputStream(this.destinationFile());
                while ((b = input.read()) != -1) {
                    output.write(b);
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
                if (output != null) {
                    output.close();
                }
            }
        } else {
            throw new Exception("Could not load resource: " + this.source);
        }
    }

    protected URL getResource(String resource) {
        return ClassLoader.getSystemResource(resource);
    }

    @Override
    public String getMessage() {
        return ".";
    }

    protected File destinationFile() {
        return new File(this.destinationDir, this.filename);
    }

    @Override
    public String getName() {
        return "FileUpdate(" + this.filename + ")";
    }

    @Override
    public boolean shouldBeApplied() throws Exception {
        return !this.destinationFile().exists();
    }
}

