/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import util.FileUtil;

public class UpdateFileList {
    private ArrayList<String> mainDirectories;
    private String updateListContent = "";
    private String updateDoNotCopyOverContent = "";
    private HashSet<String> doNotReplaceFiles = new HashSet();
    private String baseDirectory = "";
    static UpdateFileList testUpdater = null;

    public static void main(String[] args) {
        UpdateFileList updater = testUpdater != null ? testUpdater : new UpdateFileList();
        updater.parseCommandLine(args);
        if (updater.directoriesAreValid()) {
            updater.createUpdateList();
            updater.createDoNotUpdateList();
        } else {
            updater.printMessage("Some directories are invalid.");
            updater.exit();
        }
    }

    void printMessage(String message) {
        System.err.println(message);
    }

    void exit() {
        System.exit(1);
    }

    public UpdateFileList() {
        this.mainDirectories = new ArrayList();
    }

    public boolean parseCommandLine(String[] args) {
        if (args.length == 0) {
            return false;
        }
        for (String arg : args) {
            this.parseArgument(arg);
        }
        return true;
    }

    private void parseArgument(String arg) {
        if (arg.startsWith("-doNotReplace:")) {
            this.addADoNotReplaceFileName(arg);
        } else if (arg.startsWith("-baseDirectory:")) {
            this.parseBaseDirectory(arg);
        } else {
            this.mainDirectories.add(this.baseDirectory + arg);
        }
    }

    private void addADoNotReplaceFileName(String arg) {
        String[] components = arg.split(":");
        this.doNotReplaceFiles.add(components[1]);
    }

    private void parseBaseDirectory(String arg) {
        String[] components = arg.split(":");
        this.baseDirectory = components[1];
        if (!this.baseDirectory.endsWith("/")) {
            this.baseDirectory = this.baseDirectory + "/";
        }
    }

    public ArrayList<String> getDirectories() {
        return this.mainDirectories;
    }

    public boolean directoriesAreValid() {
        for (String dirName : this.mainDirectories) {
            File checkFile = new File(dirName);
            if (checkFile.exists()) continue;
            return false;
        }
        return true;
    }

    public File createUpdateList() {
        for (String dirName : this.mainDirectories) {
            this.addFilePathsToList(dirName);
        }
        return FileUtil.createFile(new File("updateList"), this.updateListContent);
    }

    private void addFilePathsToList(String directoryPath) {
        File[] files;
        File directory = new File(directoryPath);
        for (File childFile : files = FileUtil.getDirectoryListing(directory)) {
            this.addFilePathToAppropriateList(directoryPath, childFile);
        }
    }

    private void addFilePathToAppropriateList(String directoryPath, File childFile) {
        String childPath = directoryPath + "/" + childFile.getName();
        if (childFile.isDirectory()) {
            this.addFilePathsToList(childPath);
        } else if (this.isDoNotReplaceFile(childFile)) {
            this.updateDoNotCopyOverContent = this.updateDoNotCopyOverContent + this.makePathLine(childPath);
        } else {
            this.updateListContent = this.updateListContent + this.makePathLine(childPath);
        }
    }

    private String makePathLine(String path) {
        if (this.baseDirectory != null && this.baseDirectory.length() > 0 && path.startsWith(this.baseDirectory)) {
            path = path.replace(this.baseDirectory, "");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path + "\n";
    }

    private boolean isDoNotReplaceFile(File file) {
        String name = file.getPath();
        String baseDirectoryOnOS = this.baseDirectory.replace("/", File.separator);
        name = name.replace(baseDirectoryOnOS, "");
        name = name.replace(File.separator, "/");
        return this.doNotReplaceFiles.contains(name);
    }

    public File createDoNotUpdateList() {
        if (this.updateDoNotCopyOverContent.equals("")) {
            for (String dirName : this.mainDirectories) {
                this.addFilePathsToList(dirName);
            }
        }
        return FileUtil.createFile(new File("updateDoNotCopyOverList"), this.updateDoNotCopyOverContent);
    }
}

