/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.CachingPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageRepository;
import fitnesse.wiki.PageType;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import util.FileSystem;

public class ExternalSuitePage
extends CachingPage {
    private static final long serialVersionUID = 1L;
    private String path;
    private FileSystem fileSystem;

    public ExternalSuitePage(String path, String name, WikiPage parent, FileSystem fileSystem) throws Exception {
        super(name, parent);
        this.path = path;
        this.fileSystem = fileSystem;
    }

    public String getFileSystemPath() {
        return this.path;
    }

    @Override
    public boolean hasChildPage(String pageName) throws Exception {
        return false;
    }

    @Override
    public PageData getDataVersion(String versionName) throws Exception {
        return null;
    }

    @Override
    protected WikiPage createChildPage(String name) throws Exception {
        return null;
    }

    @Override
    protected void loadChildren() throws Exception {
        for (WikiPage child : new PageRepository(this.fileSystem).findChildren(this)) {
            if (this.children.containsKey(child.getName())) continue;
            this.children.put(child.getName(), child);
        }
    }

    @Override
    protected PageData makePageData() throws Exception {
        PageData pageData = new PageData(this);
        pageData.setContent("!contents");
        pageData.removeAttribute("Edit");
        pageData.removeAttribute("Properties");
        pageData.removeAttribute("Versions");
        pageData.removeAttribute("Refactor");
        pageData.setAttribute(PageType.SUITE.toString(), Boolean.toString(true));
        return pageData;
    }

    @Override
    protected VersionInfo makeVersion() throws Exception {
        return null;
    }

    @Override
    protected void doCommit(PageData data) throws Exception {
    }
}

