/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.PageData;
import fitnesse.wiki.WikiPage;

public enum PageType {
    SUITE("Suite"){

        @Override
        public boolean validForPageName(String pageName) {
            return pageName.startsWith(this.toString()) && !pageName.equals("SuiteSetUp") && !pageName.equals("SuiteTearDown") || pageName.endsWith(this.toString()) || pageName.endsWith("Examples");
        }
    }
    ,
    TEST("Test"){

        @Override
        public boolean validForPageName(String pageName) {
            return pageName.startsWith(this.toString()) || pageName.endsWith(this.toString()) || pageName.startsWith("Example") && !pageName.startsWith("Examples") || pageName.endsWith("Example");
        }
    }
    ,
    STATIC("Static"){

        @Override
        public boolean validForPageName(String pageName) {
            return true;
        }
    };

    private String description;

    public static PageType fromString(String typeDescriptor) {
        for (PageType type : PageType.values()) {
            if (!type.description.equalsIgnoreCase(typeDescriptor)) continue;
            return type;
        }
        throw new IllegalArgumentException("unknown page type descriptor: " + typeDescriptor);
    }

    public static PageType fromWikiPage(WikiPage page) throws Exception {
        PageData data = page.getData();
        if (data.hasAttribute("Suite")) {
            return SUITE;
        }
        if (data.hasAttribute(TEST.toString())) {
            return TEST;
        }
        return STATIC;
    }

    public static PageType getPageTypeForPageName(String pageName) {
        for (PageType type : PageType.values()) {
            if (!type.validForPageName(pageName)) continue;
            return type;
        }
        return STATIC;
    }

    private PageType(String description) {
        this.description = description;
    }

    public String toString() {
        return this.description;
    }

    public abstract boolean validForPageName(String var1);
}

