/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki;

import fitnesse.wiki.CommitingPage;
import fitnesse.wiki.Extension;
import fitnesse.wiki.PageCrawler;
import fitnesse.wiki.PageData;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPageAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VirtualCouplingPage
implements WikiPage {
    private static final long serialVersionUID = 1L;
    private WikiPage hostPage;
    private HashMap<String, WikiPage> children = new HashMap();

    protected VirtualCouplingPage(WikiPage hostPage) {
        this.hostPage = hostPage;
    }

    public VirtualCouplingPage(WikiPage hostPage, WikiPage proxy) throws Exception {
        this.hostPage = hostPage;
        List<WikiPage> proxyChildren = proxy.getChildren();
        for (WikiPage child : proxyChildren) {
            CommitingPage wikiPage = (CommitingPage)child;
            wikiPage.parent = this;
            this.children.put(wikiPage.getName(), wikiPage);
        }
    }

    @Override
    public boolean hasChildPage(String pageName) throws Exception {
        return this.children.containsKey(pageName);
    }

    @Override
    public PageData getData() throws Exception {
        return this.hostPage.getData();
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public WikiPage addChildPage(String name) throws Exception {
        return null;
    }

    @Override
    public void removeChildPage(String name) throws Exception {
    }

    @Override
    public PageData getDataVersion(String versionName) throws Exception {
        return null;
    }

    @Override
    public WikiPage getParent() throws Exception {
        return this.hostPage.getParent();
    }

    @Override
    public void setParentForVariables(WikiPage parent) {
        this.hostPage.setParentForVariables(parent);
    }

    @Override
    public WikiPage getParentForVariables() throws Exception {
        return this.hostPage.getParentForVariables();
    }

    @Override
    public String getName() {
        return this.hostPage.getName();
    }

    @Override
    public WikiPage getChildPage(String name) throws Exception {
        WikiPage subpage = this.children.get(name);
        if (subpage == null) {
            subpage = this.hostPage.getChildPage(name);
        }
        return subpage;
    }

    @Override
    public List<WikiPage> getChildren() throws Exception {
        return new ArrayList<WikiPage>(this.children.values());
    }

    @Override
    public VersionInfo commit(PageData data) throws Exception {
        return null;
    }

    @Override
    public boolean hasExtension(String extensionName) {
        return false;
    }

    @Override
    public Extension getExtension(String extensionName) {
        return null;
    }

    @Override
    public PageCrawler getPageCrawler() {
        return this.hostPage.getPageCrawler();
    }

    @Override
    public WikiPage getHeaderPage() throws Exception {
        return null;
    }

    @Override
    public WikiPage getFooterPage() throws Exception {
        return null;
    }

    @Override
    public String getHelpText() throws Exception {
        return "Virtual coupling help text";
    }

    @Override
    public List<WikiPageAction> getActions() throws Exception {
        return null;
    }
}

