/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.html.HtmlTag;
import fitnesse.html.HtmlUtil;
import fitnesse.wikitext.parser.ContentsItemBuilder;
import fitnesse.wikitext.parser.Matcher;
import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import util.Maybe;

public class Contents
extends SymbolType
implements Rule,
Translation {
    public Contents() {
        super("Contents");
        this.wikiMatcher(new Matcher().string("!contents"));
        this.wikiRule(this);
        this.htmlTranslation(this);
    }

    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        Symbol body = parser.parseToEnd(SymbolType.Newline);
        for (Symbol option : body.getChildren()) {
            if (option.isType(SymbolType.Whitespace)) continue;
            if (!option.getContent().startsWith("-")) {
                return Symbol.nothing;
            }
            current.add(option);
        }
        current.evaluateVariables(new String[]{"HELP_TOC", "REGRACE_TOC", "PROPERTY_TOC", "FILTER_TOC", "MORE_SUFFIX_TOC"}, parser.getVariableSource());
        return new Maybe<Symbol>(current);
    }

    @Override
    public String toTarget(Translator translator, Symbol symbol) {
        ContentsItemBuilder itemBuilder = new ContentsItemBuilder(symbol, 1);
        HtmlTag contentsDiv = HtmlUtil.makeDivTag("contents");
        contentsDiv.add(HtmlUtil.makeBold("Contents:"));
        HtmlTag div = itemBuilder.buildLevel(translator.getPage(), contentsDiv);
        return div.html();
    }
}

